/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ApprovalModel {
    AUTOMATIC("AUTOMATIC"),
    MANUAL("MANUAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ApprovalModel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApprovalModel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ApprovalModel.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApprovalModel> knownValues() {
        return Stream.of(ApprovalModel.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

