/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventType {
    SYSTEM("SYSTEM"),
    CREATE_ACTION("CREATE_ACTION"),
    DELETE_ACTION("DELETE_ACTION"),
    UPDATE_ACTION("UPDATE_ACTION"),
    EXECUTE_ACTION("EXECUTE_ACTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventType> knownValues() {
        return Stream.of(EventType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

