/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.budgets.model.ActionHistoriesCopier;
import software.amazon.awssdk.services.budgets.model.ActionHistory;
import software.amazon.awssdk.services.budgets.model.BudgetsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBudgetActionHistoriesResponse
extends BudgetsResponse
implements ToCopyableBuilder<Builder, DescribeBudgetActionHistoriesResponse> {
    private static final SdkField<List<ActionHistory>> ACTION_HISTORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActionHistories").getter(DescribeBudgetActionHistoriesResponse.getter(DescribeBudgetActionHistoriesResponse::actionHistories)).setter(DescribeBudgetActionHistoriesResponse.setter(Builder::actionHistories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionHistories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionHistory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeBudgetActionHistoriesResponse.getter(DescribeBudgetActionHistoriesResponse::nextToken)).setter(DescribeBudgetActionHistoriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_HISTORIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ActionHistory> actionHistories;
    private final String nextToken;

    private DescribeBudgetActionHistoriesResponse(BuilderImpl builder) {
        super(builder);
        this.actionHistories = builder.actionHistories;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasActionHistories() {
        return this.actionHistories != null && !(this.actionHistories instanceof SdkAutoConstructList);
    }

    public final List<ActionHistory> actionHistories() {
        return this.actionHistories;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionHistories() ? this.actionHistories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetActionHistoriesResponse)) {
            return false;
        }
        DescribeBudgetActionHistoriesResponse other = (DescribeBudgetActionHistoriesResponse)((Object)obj);
        return this.hasActionHistories() == other.hasActionHistories() && Objects.equals(this.actionHistories(), other.actionHistories()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBudgetActionHistoriesResponse").add("ActionHistories", this.hasActionHistories() ? this.actionHistories() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionHistories": {
                return Optional.ofNullable(clazz.cast(this.actionHistories()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBudgetActionHistoriesResponse, T> g) {
        return obj -> g.apply((DescribeBudgetActionHistoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BudgetsResponse.BuilderImpl
    implements Builder {
        private List<ActionHistory> actionHistories = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetActionHistoriesResponse model) {
            super(model);
            this.actionHistories(model.actionHistories);
            this.nextToken(model.nextToken);
        }

        public final Collection<ActionHistory.Builder> getActionHistories() {
            if (this.actionHistories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actionHistories != null ? (Collection)this.actionHistories.stream().map(ActionHistory::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionHistories(Collection<ActionHistory> actionHistories) {
            this.actionHistories = ActionHistoriesCopier.copy(actionHistories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionHistories(ActionHistory ... actionHistories) {
            this.actionHistories(Arrays.asList(actionHistories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionHistories(Consumer<ActionHistory.Builder> ... actionHistories) {
            this.actionHistories(Stream.of(actionHistories).map(c -> (ActionHistory)((ActionHistory.Builder)ActionHistory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActionHistories(Collection<ActionHistory.BuilderImpl> actionHistories) {
            this.actionHistories = ActionHistoriesCopier.copyFromBuilder(actionHistories);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBudgetActionHistoriesResponse build() {
            return new DescribeBudgetActionHistoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BudgetsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBudgetActionHistoriesResponse> {
        public Builder actionHistories(Collection<ActionHistory> var1);

        public Builder actionHistories(ActionHistory ... var1);

        public Builder actionHistories(Consumer<ActionHistory.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

