/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.budgets.model.BudgetsRequest;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.services.budgets.model.Subscriber;
import software.amazon.awssdk.services.budgets.model.SubscribersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNotificationRequest
extends BudgetsRequest
implements ToCopyableBuilder<Builder, CreateNotificationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNotificationRequest.getter(CreateNotificationRequest::accountId)).setter(CreateNotificationRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNotificationRequest.getter(CreateNotificationRequest::budgetName)).setter(CreateNotificationRequest.setter(Builder::budgetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()}).build();
    private static final SdkField<Notification> NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateNotificationRequest.getter(CreateNotificationRequest::notification)).setter(CreateNotificationRequest.setter(Builder::notification)).constructor(Notification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()}).build();
    private static final SdkField<List<Subscriber>> SUBSCRIBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateNotificationRequest.getter(CreateNotificationRequest::subscribers)).setter(CreateNotificationRequest.setter(Builder::subscribers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscribers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subscriber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BUDGET_NAME_FIELD, NOTIFICATION_FIELD, SUBSCRIBERS_FIELD));
    private final String accountId;
    private final String budgetName;
    private final Notification notification;
    private final List<Subscriber> subscribers;

    private CreateNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.notification = builder.notification;
        this.subscribers = builder.subscribers;
    }

    public String accountId() {
        return this.accountId;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public Notification notification() {
        return this.notification;
    }

    public List<Subscriber> subscribers() {
        return this.subscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotificationRequest)) {
            return false;
        }
        CreateNotificationRequest other = (CreateNotificationRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.subscribers(), other.subscribers());
    }

    public String toString() {
        return ToString.builder((String)"CreateNotificationRequest").add("AccountId", (Object)this.accountId()).add("BudgetName", (Object)this.budgetName()).add("Notification", (Object)this.notification()).add("Subscribers", this.subscribers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "BudgetName": {
                return Optional.ofNullable(clazz.cast(this.budgetName()));
            }
            case "Notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "Subscribers": {
                return Optional.ofNullable(clazz.cast(this.subscribers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNotificationRequest, T> g) {
        return obj -> g.apply((CreateNotificationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BudgetsRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private Notification notification;
        private List<Subscriber> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotificationRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.budgetName(model.budgetName);
            this.notification(model.notification);
            this.subscribers(model.subscribers);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final Collection<Subscriber.Builder> getSubscribers() {
            return this.subscribers != null ? (Collection)this.subscribers.stream().map(Subscriber::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber ... subscribers) {
            this.subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Consumer<Subscriber.Builder> ... subscribers) {
            this.subscribers(Stream.of(subscribers).map(c -> (Subscriber)((Subscriber.Builder)Subscriber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNotificationRequest build() {
            return new CreateNotificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BudgetsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNotificationRequest> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder notification(Notification var1);

        default public Builder notification(Consumer<Notification.Builder> notification) {
            return this.notification((Notification)((Notification.Builder)Notification.builder().applyMutation(notification)).build());
        }

        public Builder subscribers(Collection<Subscriber> var1);

        public Builder subscribers(Subscriber ... var1);

        public Builder subscribers(Consumer<Subscriber.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

