/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BillingViewType {
    PRIMARY("PRIMARY"),
    BILLING_GROUP("BILLING_GROUP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BillingViewType> VALUE_MAP;
    private final String value;

    private BillingViewType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BillingViewType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BillingViewType> knownValues() {
        EnumSet<BillingViewType> knownValues = EnumSet.allOf(BillingViewType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BillingViewType.class, BillingViewType::toString);
    }
}

