/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a search result location within the content array, providing positioning information for cited content
 * using search result index and block positions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchResultLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchResultLocation.Builder, SearchResultLocation> {
    private static final SdkField<Integer> SEARCH_RESULT_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("searchResultIndex").getter(getter(SearchResultLocation::searchResultIndex))
            .setter(setter(Builder::searchResultIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchResultIndex").build()).build();

    private static final SdkField<Integer> START_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("start")
            .getter(getter(SearchResultLocation::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<Integer> END_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("end")
            .getter(getter(SearchResultLocation::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_RESULT_INDEX_FIELD,
            START_FIELD, END_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer searchResultIndex;

    private final Integer start;

    private final Integer end;

    private SearchResultLocation(BuilderImpl builder) {
        this.searchResultIndex = builder.searchResultIndex;
        this.start = builder.start;
        this.end = builder.end;
    }

    /**
     * <p>
     * The index of the search result content block where the cited content is found.
     * </p>
     * 
     * @return The index of the search result content block where the cited content is found.
     */
    public final Integer searchResultIndex() {
        return searchResultIndex;
    }

    /**
     * <p>
     * The starting position in the content array where the cited content begins.
     * </p>
     * 
     * @return The starting position in the content array where the cited content begins.
     */
    public final Integer start() {
        return start;
    }

    /**
     * <p>
     * The ending position in the content array where the cited content ends.
     * </p>
     * 
     * @return The ending position in the content array where the cited content ends.
     */
    public final Integer end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(searchResultIndex());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResultLocation)) {
            return false;
        }
        SearchResultLocation other = (SearchResultLocation) obj;
        return Objects.equals(searchResultIndex(), other.searchResultIndex()) && Objects.equals(start(), other.start())
                && Objects.equals(end(), other.end());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchResultLocation").add("SearchResultIndex", searchResultIndex()).add("Start", start())
                .add("End", end()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "searchResultIndex":
            return Optional.ofNullable(clazz.cast(searchResultIndex()));
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        case "end":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("searchResultIndex", SEARCH_RESULT_INDEX_FIELD);
        map.put("start", START_FIELD);
        map.put("end", END_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchResultLocation, T> g) {
        return obj -> g.apply((SearchResultLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchResultLocation> {
        /**
         * <p>
         * The index of the search result content block where the cited content is found.
         * </p>
         * 
         * @param searchResultIndex
         *        The index of the search result content block where the cited content is found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchResultIndex(Integer searchResultIndex);

        /**
         * <p>
         * The starting position in the content array where the cited content begins.
         * </p>
         * 
         * @param start
         *        The starting position in the content array where the cited content begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Integer start);

        /**
         * <p>
         * The ending position in the content array where the cited content ends.
         * </p>
         * 
         * @param end
         *        The ending position in the content array where the cited content ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Integer end);
    }

    static final class BuilderImpl implements Builder {
        private Integer searchResultIndex;

        private Integer start;

        private Integer end;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResultLocation model) {
            searchResultIndex(model.searchResultIndex);
            start(model.start);
            end(model.end);
        }

        public final Integer getSearchResultIndex() {
            return searchResultIndex;
        }

        public final void setSearchResultIndex(Integer searchResultIndex) {
            this.searchResultIndex = searchResultIndex;
        }

        @Override
        public final Builder searchResultIndex(Integer searchResultIndex) {
            this.searchResultIndex = searchResultIndex;
            return this;
        }

        public final Integer getStart() {
            return start;
        }

        public final void setStart(Integer start) {
            this.start = start;
        }

        @Override
        public final Builder start(Integer start) {
            this.start = start;
            return this;
        }

        public final Integer getEnd() {
            return end;
        }

        public final void setEnd(Integer end) {
            this.end = end;
        }

        @Override
        public final Builder end(Integer end) {
            this.end = end;
            return this;
        }

        @Override
        public SearchResultLocation build() {
            return new SearchResultLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
