/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the claims are definitively true and logically implied by the premises, with no possible alternative
 * interpretations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailAutomatedReasoningValidFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailAutomatedReasoningValidFinding.Builder, GuardrailAutomatedReasoningValidFinding> {
    private static final SdkField<GuardrailAutomatedReasoningTranslation> TRANSLATION_FIELD = SdkField
            .<GuardrailAutomatedReasoningTranslation> builder(MarshallingType.SDK_POJO).memberName("translation")
            .getter(getter(GuardrailAutomatedReasoningValidFinding::translation)).setter(setter(Builder::translation))
            .constructor(GuardrailAutomatedReasoningTranslation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("translation").build()).build();

    private static final SdkField<GuardrailAutomatedReasoningScenario> CLAIMS_TRUE_SCENARIO_FIELD = SdkField
            .<GuardrailAutomatedReasoningScenario> builder(MarshallingType.SDK_POJO).memberName("claimsTrueScenario")
            .getter(getter(GuardrailAutomatedReasoningValidFinding::claimsTrueScenario))
            .setter(setter(Builder::claimsTrueScenario)).constructor(GuardrailAutomatedReasoningScenario::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claimsTrueScenario").build())
            .build();

    private static final SdkField<List<GuardrailAutomatedReasoningRule>> SUPPORTING_RULES_FIELD = SdkField
            .<List<GuardrailAutomatedReasoningRule>> builder(MarshallingType.LIST)
            .memberName("supportingRules")
            .getter(getter(GuardrailAutomatedReasoningValidFinding::supportingRules))
            .setter(setter(Builder::supportingRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportingRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailAutomatedReasoningRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailAutomatedReasoningRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<GuardrailAutomatedReasoningLogicWarning> LOGIC_WARNING_FIELD = SdkField
            .<GuardrailAutomatedReasoningLogicWarning> builder(MarshallingType.SDK_POJO).memberName("logicWarning")
            .getter(getter(GuardrailAutomatedReasoningValidFinding::logicWarning)).setter(setter(Builder::logicWarning))
            .constructor(GuardrailAutomatedReasoningLogicWarning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicWarning").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATION_FIELD,
            CLAIMS_TRUE_SCENARIO_FIELD, SUPPORTING_RULES_FIELD, LOGIC_WARNING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GuardrailAutomatedReasoningTranslation translation;

    private final GuardrailAutomatedReasoningScenario claimsTrueScenario;

    private final List<GuardrailAutomatedReasoningRule> supportingRules;

    private final GuardrailAutomatedReasoningLogicWarning logicWarning;

    private GuardrailAutomatedReasoningValidFinding(BuilderImpl builder) {
        this.translation = builder.translation;
        this.claimsTrueScenario = builder.claimsTrueScenario;
        this.supportingRules = builder.supportingRules;
        this.logicWarning = builder.logicWarning;
    }

    /**
     * <p>
     * The logical translation of the input that this finding validates.
     * </p>
     * 
     * @return The logical translation of the input that this finding validates.
     */
    public final GuardrailAutomatedReasoningTranslation translation() {
        return translation;
    }

    /**
     * <p>
     * An example scenario demonstrating how the claims are logically true.
     * </p>
     * 
     * @return An example scenario demonstrating how the claims are logically true.
     */
    public final GuardrailAutomatedReasoningScenario claimsTrueScenario() {
        return claimsTrueScenario;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportingRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportingRules() {
        return supportingRules != null && !(supportingRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The automated reasoning policy rules that support why this result is considered valid.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportingRules} method.
     * </p>
     * 
     * @return The automated reasoning policy rules that support why this result is considered valid.
     */
    public final List<GuardrailAutomatedReasoningRule> supportingRules() {
        return supportingRules;
    }

    /**
     * <p>
     * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
     * rules.
     * </p>
     * 
     * @return Indication of a logic issue with the translation without needing to consider the automated reasoning
     *         policy rules.
     */
    public final GuardrailAutomatedReasoningLogicWarning logicWarning() {
        return logicWarning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(translation());
        hashCode = 31 * hashCode + Objects.hashCode(claimsTrueScenario());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportingRules() ? supportingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logicWarning());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAutomatedReasoningValidFinding)) {
            return false;
        }
        GuardrailAutomatedReasoningValidFinding other = (GuardrailAutomatedReasoningValidFinding) obj;
        return Objects.equals(translation(), other.translation())
                && Objects.equals(claimsTrueScenario(), other.claimsTrueScenario())
                && hasSupportingRules() == other.hasSupportingRules()
                && Objects.equals(supportingRules(), other.supportingRules())
                && Objects.equals(logicWarning(), other.logicWarning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailAutomatedReasoningValidFinding").add("Translation", translation())
                .add("ClaimsTrueScenario", claimsTrueScenario())
                .add("SupportingRules", hasSupportingRules() ? supportingRules() : null).add("LogicWarning", logicWarning())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "translation":
            return Optional.ofNullable(clazz.cast(translation()));
        case "claimsTrueScenario":
            return Optional.ofNullable(clazz.cast(claimsTrueScenario()));
        case "supportingRules":
            return Optional.ofNullable(clazz.cast(supportingRules()));
        case "logicWarning":
            return Optional.ofNullable(clazz.cast(logicWarning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("translation", TRANSLATION_FIELD);
        map.put("claimsTrueScenario", CLAIMS_TRUE_SCENARIO_FIELD);
        map.put("supportingRules", SUPPORTING_RULES_FIELD);
        map.put("logicWarning", LOGIC_WARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAutomatedReasoningValidFinding, T> g) {
        return obj -> g.apply((GuardrailAutomatedReasoningValidFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailAutomatedReasoningValidFinding> {
        /**
         * <p>
         * The logical translation of the input that this finding validates.
         * </p>
         * 
         * @param translation
         *        The logical translation of the input that this finding validates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder translation(GuardrailAutomatedReasoningTranslation translation);

        /**
         * <p>
         * The logical translation of the input that this finding validates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningTranslation.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningTranslation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningTranslation.Builder#build()} is called
         * immediately and its result is passed to {@link #translation(GuardrailAutomatedReasoningTranslation)}.
         * 
         * @param translation
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningTranslation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #translation(GuardrailAutomatedReasoningTranslation)
         */
        default Builder translation(Consumer<GuardrailAutomatedReasoningTranslation.Builder> translation) {
            return translation(GuardrailAutomatedReasoningTranslation.builder().applyMutation(translation).build());
        }

        /**
         * <p>
         * An example scenario demonstrating how the claims are logically true.
         * </p>
         * 
         * @param claimsTrueScenario
         *        An example scenario demonstrating how the claims are logically true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claimsTrueScenario(GuardrailAutomatedReasoningScenario claimsTrueScenario);

        /**
         * <p>
         * An example scenario demonstrating how the claims are logically true.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningScenario.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningScenario#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningScenario.Builder#build()} is called
         * immediately and its result is passed to {@link #claimsTrueScenario(GuardrailAutomatedReasoningScenario)}.
         * 
         * @param claimsTrueScenario
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningScenario.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #claimsTrueScenario(GuardrailAutomatedReasoningScenario)
         */
        default Builder claimsTrueScenario(Consumer<GuardrailAutomatedReasoningScenario.Builder> claimsTrueScenario) {
            return claimsTrueScenario(GuardrailAutomatedReasoningScenario.builder().applyMutation(claimsTrueScenario).build());
        }

        /**
         * <p>
         * The automated reasoning policy rules that support why this result is considered valid.
         * </p>
         * 
         * @param supportingRules
         *        The automated reasoning policy rules that support why this result is considered valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportingRules(Collection<GuardrailAutomatedReasoningRule> supportingRules);

        /**
         * <p>
         * The automated reasoning policy rules that support why this result is considered valid.
         * </p>
         * 
         * @param supportingRules
         *        The automated reasoning policy rules that support why this result is considered valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportingRules(GuardrailAutomatedReasoningRule... supportingRules);

        /**
         * <p>
         * The automated reasoning policy rules that support why this result is considered valid.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningRule.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningRule.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #supportingRules(List<GuardrailAutomatedReasoningRule>)}.
         * 
         * @param supportingRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportingRules(java.util.Collection<GuardrailAutomatedReasoningRule>)
         */
        Builder supportingRules(Consumer<GuardrailAutomatedReasoningRule.Builder>... supportingRules);

        /**
         * <p>
         * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
         * rules.
         * </p>
         * 
         * @param logicWarning
         *        Indication of a logic issue with the translation without needing to consider the automated reasoning
         *        policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicWarning(GuardrailAutomatedReasoningLogicWarning logicWarning);

        /**
         * <p>
         * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
         * rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningLogicWarning.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningLogicWarning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningLogicWarning.Builder#build()} is
         * called immediately and its result is passed to {@link #logicWarning(GuardrailAutomatedReasoningLogicWarning)}.
         * 
         * @param logicWarning
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningLogicWarning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logicWarning(GuardrailAutomatedReasoningLogicWarning)
         */
        default Builder logicWarning(Consumer<GuardrailAutomatedReasoningLogicWarning.Builder> logicWarning) {
            return logicWarning(GuardrailAutomatedReasoningLogicWarning.builder().applyMutation(logicWarning).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GuardrailAutomatedReasoningTranslation translation;

        private GuardrailAutomatedReasoningScenario claimsTrueScenario;

        private List<GuardrailAutomatedReasoningRule> supportingRules = DefaultSdkAutoConstructList.getInstance();

        private GuardrailAutomatedReasoningLogicWarning logicWarning;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAutomatedReasoningValidFinding model) {
            translation(model.translation);
            claimsTrueScenario(model.claimsTrueScenario);
            supportingRules(model.supportingRules);
            logicWarning(model.logicWarning);
        }

        public final GuardrailAutomatedReasoningTranslation.Builder getTranslation() {
            return translation != null ? translation.toBuilder() : null;
        }

        public final void setTranslation(GuardrailAutomatedReasoningTranslation.BuilderImpl translation) {
            this.translation = translation != null ? translation.build() : null;
        }

        @Override
        public final Builder translation(GuardrailAutomatedReasoningTranslation translation) {
            this.translation = translation;
            return this;
        }

        public final GuardrailAutomatedReasoningScenario.Builder getClaimsTrueScenario() {
            return claimsTrueScenario != null ? claimsTrueScenario.toBuilder() : null;
        }

        public final void setClaimsTrueScenario(GuardrailAutomatedReasoningScenario.BuilderImpl claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario != null ? claimsTrueScenario.build() : null;
        }

        @Override
        public final Builder claimsTrueScenario(GuardrailAutomatedReasoningScenario claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario;
            return this;
        }

        public final List<GuardrailAutomatedReasoningRule.Builder> getSupportingRules() {
            List<GuardrailAutomatedReasoningRule.Builder> result = GuardrailAutomatedReasoningRuleListCopier
                    .copyToBuilder(this.supportingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportingRules(Collection<GuardrailAutomatedReasoningRule.BuilderImpl> supportingRules) {
            this.supportingRules = GuardrailAutomatedReasoningRuleListCopier.copyFromBuilder(supportingRules);
        }

        @Override
        public final Builder supportingRules(Collection<GuardrailAutomatedReasoningRule> supportingRules) {
            this.supportingRules = GuardrailAutomatedReasoningRuleListCopier.copy(supportingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingRules(GuardrailAutomatedReasoningRule... supportingRules) {
            supportingRules(Arrays.asList(supportingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingRules(Consumer<GuardrailAutomatedReasoningRule.Builder>... supportingRules) {
            supportingRules(Stream.of(supportingRules)
                    .map(c -> GuardrailAutomatedReasoningRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final GuardrailAutomatedReasoningLogicWarning.Builder getLogicWarning() {
            return logicWarning != null ? logicWarning.toBuilder() : null;
        }

        public final void setLogicWarning(GuardrailAutomatedReasoningLogicWarning.BuilderImpl logicWarning) {
            this.logicWarning = logicWarning != null ? logicWarning.build() : null;
        }

        @Override
        public final Builder logicWarning(GuardrailAutomatedReasoningLogicWarning logicWarning) {
            this.logicWarning = logicWarning;
            return this;
        }

        @Override
        public GuardrailAutomatedReasoningValidFinding build() {
            return new GuardrailAutomatedReasoningValidFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
