/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the input has multiple valid logical interpretations, requiring additional context or clarification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailAutomatedReasoningTranslationAmbiguousFinding
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<GuardrailAutomatedReasoningTranslationAmbiguousFinding.Builder, GuardrailAutomatedReasoningTranslationAmbiguousFinding> {
    private static final SdkField<List<GuardrailAutomatedReasoningTranslationOption>> OPTIONS_FIELD = SdkField
            .<List<GuardrailAutomatedReasoningTranslationOption>> builder(MarshallingType.LIST)
            .memberName("options")
            .getter(getter(GuardrailAutomatedReasoningTranslationAmbiguousFinding::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailAutomatedReasoningTranslationOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailAutomatedReasoningTranslationOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GuardrailAutomatedReasoningScenario>> DIFFERENCE_SCENARIOS_FIELD = SdkField
            .<List<GuardrailAutomatedReasoningScenario>> builder(MarshallingType.LIST)
            .memberName("differenceScenarios")
            .getter(getter(GuardrailAutomatedReasoningTranslationAmbiguousFinding::differenceScenarios))
            .setter(setter(Builder::differenceScenarios))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("differenceScenarios").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailAutomatedReasoningScenario> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailAutomatedReasoningScenario::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD,
            DIFFERENCE_SCENARIOS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GuardrailAutomatedReasoningTranslationOption> options;

    private final List<GuardrailAutomatedReasoningScenario> differenceScenarios;

    private GuardrailAutomatedReasoningTranslationAmbiguousFinding(BuilderImpl builder) {
        this.options = builder.options;
        this.differenceScenarios = builder.differenceScenarios;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Different logical interpretations that were detected during translation of the input.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return Different logical interpretations that were detected during translation of the input.
     */
    public final List<GuardrailAutomatedReasoningTranslationOption> options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the DifferenceScenarios property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDifferenceScenarios() {
        return differenceScenarios != null && !(differenceScenarios instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Scenarios showing how the different translation options differ in meaning.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDifferenceScenarios} method.
     * </p>
     * 
     * @return Scenarios showing how the different translation options differ in meaning.
     */
    public final List<GuardrailAutomatedReasoningScenario> differenceScenarios() {
        return differenceScenarios;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDifferenceScenarios() ? differenceScenarios() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAutomatedReasoningTranslationAmbiguousFinding)) {
            return false;
        }
        GuardrailAutomatedReasoningTranslationAmbiguousFinding other = (GuardrailAutomatedReasoningTranslationAmbiguousFinding) obj;
        return hasOptions() == other.hasOptions() && Objects.equals(options(), other.options())
                && hasDifferenceScenarios() == other.hasDifferenceScenarios()
                && Objects.equals(differenceScenarios(), other.differenceScenarios());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailAutomatedReasoningTranslationAmbiguousFinding")
                .add("Options", hasOptions() ? options() : null)
                .add("DifferenceScenarios", hasDifferenceScenarios() ? differenceScenarios() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "options":
            return Optional.ofNullable(clazz.cast(options()));
        case "differenceScenarios":
            return Optional.ofNullable(clazz.cast(differenceScenarios()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("options", OPTIONS_FIELD);
        map.put("differenceScenarios", DIFFERENCE_SCENARIOS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAutomatedReasoningTranslationAmbiguousFinding, T> g) {
        return obj -> g.apply((GuardrailAutomatedReasoningTranslationAmbiguousFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailAutomatedReasoningTranslationAmbiguousFinding> {
        /**
         * <p>
         * Different logical interpretations that were detected during translation of the input.
         * </p>
         * 
         * @param options
         *        Different logical interpretations that were detected during translation of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<GuardrailAutomatedReasoningTranslationOption> options);

        /**
         * <p>
         * Different logical interpretations that were detected during translation of the input.
         * </p>
         * 
         * @param options
         *        Different logical interpretations that were detected during translation of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(GuardrailAutomatedReasoningTranslationOption... options);

        /**
         * <p>
         * Different logical interpretations that were detected during translation of the input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningTranslationOption.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningTranslationOption#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningTranslationOption.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #options(List<GuardrailAutomatedReasoningTranslationOption>)}.
         * 
         * @param options
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningTranslationOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(java.util.Collection<GuardrailAutomatedReasoningTranslationOption>)
         */
        Builder options(Consumer<GuardrailAutomatedReasoningTranslationOption.Builder>... options);

        /**
         * <p>
         * Scenarios showing how the different translation options differ in meaning.
         * </p>
         * 
         * @param differenceScenarios
         *        Scenarios showing how the different translation options differ in meaning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder differenceScenarios(Collection<GuardrailAutomatedReasoningScenario> differenceScenarios);

        /**
         * <p>
         * Scenarios showing how the different translation options differ in meaning.
         * </p>
         * 
         * @param differenceScenarios
         *        Scenarios showing how the different translation options differ in meaning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder differenceScenarios(GuardrailAutomatedReasoningScenario... differenceScenarios);

        /**
         * <p>
         * Scenarios showing how the different translation options differ in meaning.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningScenario.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningScenario#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningScenario.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #differenceScenarios(List<GuardrailAutomatedReasoningScenario>)}.
         * 
         * @param differenceScenarios
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningScenario.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #differenceScenarios(java.util.Collection<GuardrailAutomatedReasoningScenario>)
         */
        Builder differenceScenarios(Consumer<GuardrailAutomatedReasoningScenario.Builder>... differenceScenarios);
    }

    static final class BuilderImpl implements Builder {
        private List<GuardrailAutomatedReasoningTranslationOption> options = DefaultSdkAutoConstructList.getInstance();

        private List<GuardrailAutomatedReasoningScenario> differenceScenarios = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAutomatedReasoningTranslationAmbiguousFinding model) {
            options(model.options);
            differenceScenarios(model.differenceScenarios);
        }

        public final List<GuardrailAutomatedReasoningTranslationOption.Builder> getOptions() {
            List<GuardrailAutomatedReasoningTranslationOption.Builder> result = GuardrailAutomatedReasoningTranslationOptionListCopier
                    .copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<GuardrailAutomatedReasoningTranslationOption.BuilderImpl> options) {
            this.options = GuardrailAutomatedReasoningTranslationOptionListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<GuardrailAutomatedReasoningTranslationOption> options) {
            this.options = GuardrailAutomatedReasoningTranslationOptionListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(GuardrailAutomatedReasoningTranslationOption... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<GuardrailAutomatedReasoningTranslationOption.Builder>... options) {
            options(Stream.of(options).map(c -> GuardrailAutomatedReasoningTranslationOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailAutomatedReasoningScenario.Builder> getDifferenceScenarios() {
            List<GuardrailAutomatedReasoningScenario.Builder> result = GuardrailAutomatedReasoningDifferenceScenarioListCopier
                    .copyToBuilder(this.differenceScenarios);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDifferenceScenarios(Collection<GuardrailAutomatedReasoningScenario.BuilderImpl> differenceScenarios) {
            this.differenceScenarios = GuardrailAutomatedReasoningDifferenceScenarioListCopier
                    .copyFromBuilder(differenceScenarios);
        }

        @Override
        public final Builder differenceScenarios(Collection<GuardrailAutomatedReasoningScenario> differenceScenarios) {
            this.differenceScenarios = GuardrailAutomatedReasoningDifferenceScenarioListCopier.copy(differenceScenarios);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder differenceScenarios(GuardrailAutomatedReasoningScenario... differenceScenarios) {
            differenceScenarios(Arrays.asList(differenceScenarios));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder differenceScenarios(Consumer<GuardrailAutomatedReasoningScenario.Builder>... differenceScenarios) {
            differenceScenarios(Stream.of(differenceScenarios)
                    .map(c -> GuardrailAutomatedReasoningScenario.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GuardrailAutomatedReasoningTranslationAmbiguousFinding build() {
            return new GuardrailAutomatedReasoningTranslationAmbiguousFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
