/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A document to include in a message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentBlock implements SdkPojo, Serializable, ToCopyableBuilder<DocumentBlock.Builder, DocumentBlock> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(DocumentBlock::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DocumentBlock::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<DocumentSource> SOURCE_FIELD = SdkField.<DocumentSource> builder(MarshallingType.SDK_POJO)
            .memberName("source").getter(getter(DocumentBlock::source)).setter(setter(Builder::source))
            .constructor(DocumentSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("context")
            .getter(getter(DocumentBlock::context)).setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final SdkField<CitationsConfig> CITATIONS_FIELD = SdkField.<CitationsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("citations").getter(getter(DocumentBlock::citations)).setter(setter(Builder::citations))
            .constructor(CitationsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAME_FIELD,
            SOURCE_FIELD, CONTEXT_FIELD, CITATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String name;

    private final DocumentSource source;

    private final String context;

    private final CitationsConfig citations;

    private DocumentBlock(BuilderImpl builder) {
        this.format = builder.format;
        this.name = builder.name;
        this.source = builder.source;
        this.context = builder.context;
        this.citations = builder.citations;
    }

    /**
     * <p>
     * The format of a document, or its extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link DocumentFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of a document, or its extension.
     * @see DocumentFormat
     */
    public final DocumentFormat format() {
        return DocumentFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of a document, or its extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link DocumentFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of a document, or its extension.
     * @see DocumentFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * A name for the document. The name can only contain the following characters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Alphanumeric characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Whitespace characters (no more than one in a row)
     * </p>
     * </li>
     * <li>
     * <p>
     * Hyphens
     * </p>
     * </li>
     * <li>
     * <p>
     * Parentheses
     * </p>
     * </li>
     * <li>
     * <p>
     * Square brackets
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This field is vulnerable to prompt injections, because the model might inadvertently interpret it as
     * instructions. Therefore, we recommend that you specify a neutral name.
     * </p>
     * </note>
     * 
     * @return A name for the document. The name can only contain the following characters:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Alphanumeric characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Whitespace characters (no more than one in a row)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Hyphens
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Parentheses
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Square brackets
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         This field is vulnerable to prompt injections, because the model might inadvertently interpret it as
     *         instructions. Therefore, we recommend that you specify a neutral name.
     *         </p>
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Contains the content of the document.
     * </p>
     * 
     * @return Contains the content of the document.
     */
    public final DocumentSource source() {
        return source;
    }

    /**
     * <p>
     * Contextual information about how the document should be processed or interpreted by the model when generating
     * citations.
     * </p>
     * 
     * @return Contextual information about how the document should be processed or interpreted by the model when
     *         generating citations.
     */
    public final String context() {
        return context;
    }

    /**
     * <p>
     * Configuration settings that control how citations should be generated for this specific document.
     * </p>
     * 
     * @return Configuration settings that control how citations should be generated for this specific document.
     */
    public final CitationsConfig citations() {
        return citations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(citations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentBlock)) {
            return false;
        }
        DocumentBlock other = (DocumentBlock) obj;
        return Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(source(), other.source()) && Objects.equals(context(), other.context())
                && Objects.equals(citations(), other.citations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentBlock").add("Format", formatAsString()).add("Name", name()).add("Source", source())
                .add("Context", context()).add("Citations", citations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        case "citations":
            return Optional.ofNullable(clazz.cast(citations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("format", FORMAT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("context", CONTEXT_FIELD);
        map.put("citations", CITATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentBlock, T> g) {
        return obj -> g.apply((DocumentBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentBlock> {
        /**
         * <p>
         * The format of a document, or its extension.
         * </p>
         * 
         * @param format
         *        The format of a document, or its extension.
         * @see DocumentFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of a document, or its extension.
         * </p>
         * 
         * @param format
         *        The format of a document, or its extension.
         * @see DocumentFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentFormat
         */
        Builder format(DocumentFormat format);

        /**
         * <p>
         * A name for the document. The name can only contain the following characters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Alphanumeric characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Whitespace characters (no more than one in a row)
         * </p>
         * </li>
         * <li>
         * <p>
         * Hyphens
         * </p>
         * </li>
         * <li>
         * <p>
         * Parentheses
         * </p>
         * </li>
         * <li>
         * <p>
         * Square brackets
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * This field is vulnerable to prompt injections, because the model might inadvertently interpret it as
         * instructions. Therefore, we recommend that you specify a neutral name.
         * </p>
         * </note>
         * 
         * @param name
         *        A name for the document. The name can only contain the following characters:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Alphanumeric characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Whitespace characters (no more than one in a row)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Hyphens
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Parentheses
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Square brackets
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        This field is vulnerable to prompt injections, because the model might inadvertently interpret it as
         *        instructions. Therefore, we recommend that you specify a neutral name.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Contains the content of the document.
         * </p>
         * 
         * @param source
         *        Contains the content of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(DocumentSource source);

        /**
         * <p>
         * Contains the content of the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentSource.Builder} avoiding the need
         * to create one manually via {@link DocumentSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(DocumentSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link DocumentSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(DocumentSource)
         */
        default Builder source(Consumer<DocumentSource.Builder> source) {
            return source(DocumentSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * Contextual information about how the document should be processed or interpreted by the model when generating
         * citations.
         * </p>
         * 
         * @param context
         *        Contextual information about how the document should be processed or interpreted by the model when
         *        generating citations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(String context);

        /**
         * <p>
         * Configuration settings that control how citations should be generated for this specific document.
         * </p>
         * 
         * @param citations
         *        Configuration settings that control how citations should be generated for this specific document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citations(CitationsConfig citations);

        /**
         * <p>
         * Configuration settings that control how citations should be generated for this specific document.
         * </p>
         * This is a convenience method that creates an instance of the {@link CitationsConfig.Builder} avoiding the
         * need to create one manually via {@link CitationsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CitationsConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #citations(CitationsConfig)}.
         * 
         * @param citations
         *        a consumer that will call methods on {@link CitationsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #citations(CitationsConfig)
         */
        default Builder citations(Consumer<CitationsConfig.Builder> citations) {
            return citations(CitationsConfig.builder().applyMutation(citations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String name;

        private DocumentSource source;

        private String context;

        private CitationsConfig citations;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentBlock model) {
            format(model.format);
            name(model.name);
            source(model.source);
            context(model.context);
            citations(model.citations);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(DocumentFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DocumentSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(DocumentSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(DocumentSource source) {
            this.source = source;
            return this;
        }

        public final String getContext() {
            return context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final CitationsConfig.Builder getCitations() {
            return citations != null ? citations.toBuilder() : null;
        }

        public final void setCitations(CitationsConfig.BuilderImpl citations) {
            this.citations = citations != null ? citations.build() : null;
        }

        @Override
        public final Builder citations(CitationsConfig citations) {
            this.citations = citations;
            return this;
        }

        @Override
        public DocumentBlock build() {
            return new DocumentBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
