/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input value for token counting. The value should be either an <code>InvokeModel</code> or <code>Converse</code>
 * request body.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CountTokensInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CountTokensInput.Builder, CountTokensInput> {
    private static final SdkField<InvokeModelTokensRequest> INVOKE_MODEL_FIELD = SdkField
            .<InvokeModelTokensRequest> builder(MarshallingType.SDK_POJO).memberName("invokeModel")
            .getter(getter(CountTokensInput::invokeModel)).setter(setter(Builder::invokeModel))
            .constructor(InvokeModelTokensRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokeModel").build()).build();

    private static final SdkField<ConverseTokensRequest> CONVERSE_FIELD = SdkField
            .<ConverseTokensRequest> builder(MarshallingType.SDK_POJO).memberName("converse")
            .getter(getter(CountTokensInput::converse)).setter(setter(Builder::converse))
            .constructor(ConverseTokensRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("converse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOKE_MODEL_FIELD,
            CONVERSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InvokeModelTokensRequest invokeModel;

    private final ConverseTokensRequest converse;

    private final Type type;

    private CountTokensInput(BuilderImpl builder) {
        this.invokeModel = builder.invokeModel;
        this.converse = builder.converse;
        this.type = builder.type;
    }

    /**
     * <p>
     * An <code>InvokeModel</code> request for which to count tokens. Use this field when you want to count tokens for a
     * raw text input that would be sent to the <code>InvokeModel</code> operation.
     * </p>
     * 
     * @return An <code>InvokeModel</code> request for which to count tokens. Use this field when you want to count
     *         tokens for a raw text input that would be sent to the <code>InvokeModel</code> operation.
     */
    public final InvokeModelTokensRequest invokeModel() {
        return invokeModel;
    }

    /**
     * <p>
     * A <code>Converse</code> request for which to count tokens. Use this field when you want to count tokens for a
     * conversation-based input that would be sent to the <code>Converse</code> operation.
     * </p>
     * 
     * @return A <code>Converse</code> request for which to count tokens. Use this field when you want to count tokens
     *         for a conversation-based input that would be sent to the <code>Converse</code> operation.
     */
    public final ConverseTokensRequest converse() {
        return converse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invokeModel());
        hashCode = 31 * hashCode + Objects.hashCode(converse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountTokensInput)) {
            return false;
        }
        CountTokensInput other = (CountTokensInput) obj;
        return Objects.equals(invokeModel(), other.invokeModel()) && Objects.equals(converse(), other.converse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CountTokensInput").add("InvokeModel", invokeModel()).add("Converse", converse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invokeModel":
            return Optional.ofNullable(clazz.cast(invokeModel()));
        case "converse":
            return Optional.ofNullable(clazz.cast(converse()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #invokeModel()} initialized to the given value.
     *
     * <p>
     * An <code>InvokeModel</code> request for which to count tokens. Use this field when you want to count tokens for a
     * raw text input that would be sent to the <code>InvokeModel</code> operation.
     * </p>
     * 
     * @param invokeModel
     *        An <code>InvokeModel</code> request for which to count tokens. Use this field when you want to count
     *        tokens for a raw text input that would be sent to the <code>InvokeModel</code> operation.
     */
    public static CountTokensInput fromInvokeModel(InvokeModelTokensRequest invokeModel) {
        return builder().invokeModel(invokeModel).build();
    }

    /**
     * Create an instance of this class with {@link #invokeModel()} initialized to the given value.
     *
     * <p>
     * An <code>InvokeModel</code> request for which to count tokens. Use this field when you want to count tokens for a
     * raw text input that would be sent to the <code>InvokeModel</code> operation.
     * </p>
     * 
     * @param invokeModel
     *        An <code>InvokeModel</code> request for which to count tokens. Use this field when you want to count
     *        tokens for a raw text input that would be sent to the <code>InvokeModel</code> operation.
     */
    public static CountTokensInput fromInvokeModel(Consumer<InvokeModelTokensRequest.Builder> invokeModel) {
        InvokeModelTokensRequest.Builder builder = InvokeModelTokensRequest.builder();
        invokeModel.accept(builder);
        return fromInvokeModel(builder.build());
    }

    /**
     * Create an instance of this class with {@link #converse()} initialized to the given value.
     *
     * <p>
     * A <code>Converse</code> request for which to count tokens. Use this field when you want to count tokens for a
     * conversation-based input that would be sent to the <code>Converse</code> operation.
     * </p>
     * 
     * @param converse
     *        A <code>Converse</code> request for which to count tokens. Use this field when you want to count tokens
     *        for a conversation-based input that would be sent to the <code>Converse</code> operation.
     */
    public static CountTokensInput fromConverse(ConverseTokensRequest converse) {
        return builder().converse(converse).build();
    }

    /**
     * Create an instance of this class with {@link #converse()} initialized to the given value.
     *
     * <p>
     * A <code>Converse</code> request for which to count tokens. Use this field when you want to count tokens for a
     * conversation-based input that would be sent to the <code>Converse</code> operation.
     * </p>
     * 
     * @param converse
     *        A <code>Converse</code> request for which to count tokens. Use this field when you want to count tokens
     *        for a conversation-based input that would be sent to the <code>Converse</code> operation.
     */
    public static CountTokensInput fromConverse(Consumer<ConverseTokensRequest.Builder> converse) {
        ConverseTokensRequest.Builder builder = ConverseTokensRequest.builder();
        converse.accept(builder);
        return fromConverse(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invokeModel", INVOKE_MODEL_FIELD);
        map.put("converse", CONVERSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CountTokensInput, T> g) {
        return obj -> g.apply((CountTokensInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CountTokensInput> {
        /**
         * <p>
         * An <code>InvokeModel</code> request for which to count tokens. Use this field when you want to count tokens
         * for a raw text input that would be sent to the <code>InvokeModel</code> operation.
         * </p>
         * 
         * @param invokeModel
         *        An <code>InvokeModel</code> request for which to count tokens. Use this field when you want to count
         *        tokens for a raw text input that would be sent to the <code>InvokeModel</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokeModel(InvokeModelTokensRequest invokeModel);

        /**
         * <p>
         * An <code>InvokeModel</code> request for which to count tokens. Use this field when you want to count tokens
         * for a raw text input that would be sent to the <code>InvokeModel</code> operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvokeModelTokensRequest.Builder}
         * avoiding the need to create one manually via {@link InvokeModelTokensRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvokeModelTokensRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #invokeModel(InvokeModelTokensRequest)}.
         * 
         * @param invokeModel
         *        a consumer that will call methods on {@link InvokeModelTokensRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invokeModel(InvokeModelTokensRequest)
         */
        default Builder invokeModel(Consumer<InvokeModelTokensRequest.Builder> invokeModel) {
            return invokeModel(InvokeModelTokensRequest.builder().applyMutation(invokeModel).build());
        }

        /**
         * <p>
         * A <code>Converse</code> request for which to count tokens. Use this field when you want to count tokens for a
         * conversation-based input that would be sent to the <code>Converse</code> operation.
         * </p>
         * 
         * @param converse
         *        A <code>Converse</code> request for which to count tokens. Use this field when you want to count
         *        tokens for a conversation-based input that would be sent to the <code>Converse</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder converse(ConverseTokensRequest converse);

        /**
         * <p>
         * A <code>Converse</code> request for which to count tokens. Use this field when you want to count tokens for a
         * conversation-based input that would be sent to the <code>Converse</code> operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConverseTokensRequest.Builder} avoiding
         * the need to create one manually via {@link ConverseTokensRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConverseTokensRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #converse(ConverseTokensRequest)}.
         * 
         * @param converse
         *        a consumer that will call methods on {@link ConverseTokensRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #converse(ConverseTokensRequest)
         */
        default Builder converse(Consumer<ConverseTokensRequest.Builder> converse) {
            return converse(ConverseTokensRequest.builder().applyMutation(converse).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InvokeModelTokensRequest invokeModel;

        private ConverseTokensRequest converse;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CountTokensInput model) {
            invokeModel(model.invokeModel);
            converse(model.converse);
        }

        public final InvokeModelTokensRequest.Builder getInvokeModel() {
            return invokeModel != null ? invokeModel.toBuilder() : null;
        }

        public final void setInvokeModel(InvokeModelTokensRequest.BuilderImpl invokeModel) {
            Object oldValue = this.invokeModel;
            this.invokeModel = invokeModel != null ? invokeModel.build() : null;
            handleUnionValueChange(Type.INVOKE_MODEL, oldValue, this.invokeModel);
        }

        @Override
        public final Builder invokeModel(InvokeModelTokensRequest invokeModel) {
            Object oldValue = this.invokeModel;
            this.invokeModel = invokeModel;
            handleUnionValueChange(Type.INVOKE_MODEL, oldValue, this.invokeModel);
            return this;
        }

        public final ConverseTokensRequest.Builder getConverse() {
            return converse != null ? converse.toBuilder() : null;
        }

        public final void setConverse(ConverseTokensRequest.BuilderImpl converse) {
            Object oldValue = this.converse;
            this.converse = converse != null ? converse.build() : null;
            handleUnionValueChange(Type.CONVERSE, oldValue, this.converse);
        }

        @Override
        public final Builder converse(ConverseTokensRequest converse) {
            Object oldValue = this.converse;
            this.converse = converse;
            handleUnionValueChange(Type.CONVERSE, oldValue, this.converse);
            return this;
        }

        @Override
        public CountTokensInput build() {
            return new CountTokensInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CountTokensInput#type()
     */
    public enum Type {
        INVOKE_MODEL,

        CONVERSE,

        UNKNOWN_TO_SDK_VERSION
    }
}
