/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The inputs from a <code>Converse</code> API request for token counting.
 * </p>
 * <p>
 * This structure mirrors the input format for the <code>Converse</code> operation, allowing you to count tokens for
 * conversation-based inference requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConverseTokensRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ConverseTokensRequest.Builder, ConverseTokensRequest> {
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField
            .<List<Message>> builder(MarshallingType.LIST)
            .memberName("messages")
            .getter(getter(ConverseTokensRequest::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Message> builder(MarshallingType.SDK_POJO)
                                            .constructor(Message::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SystemContentBlock>> SYSTEM_FIELD = SdkField
            .<List<SystemContentBlock>> builder(MarshallingType.LIST)
            .memberName("system")
            .getter(getter(ConverseTokensRequest::system))
            .setter(setter(Builder::system))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("system").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SystemContentBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(SystemContentBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ToolConfiguration> TOOL_CONFIG_FIELD = SdkField
            .<ToolConfiguration> builder(MarshallingType.SDK_POJO).memberName("toolConfig")
            .getter(getter(ConverseTokensRequest::toolConfig)).setter(setter(Builder::toolConfig))
            .constructor(ToolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolConfig").build()).build();

    private static final SdkField<Document> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT)
            .memberName("additionalModelRequestFields")
            .getter(getter(ConverseTokensRequest::additionalModelRequestFields))
            .setter(setter(Builder::additionalModelRequestFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD, SYSTEM_FIELD,
            TOOL_CONFIG_FIELD, ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Message> messages;

    private final List<SystemContentBlock> system;

    private final ToolConfiguration toolConfig;

    private final Document additionalModelRequestFields;

    private ConverseTokensRequest(BuilderImpl builder) {
        this.messages = builder.messages;
        this.system = builder.system;
        this.toolConfig = builder.toolConfig;
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of messages to count tokens for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return An array of messages to count tokens for.
     */
    public final List<Message> messages() {
        return messages;
    }

    /**
     * For responses, this returns true if the service returned a value for the System property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSystem() {
        return system != null && !(system instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The system content blocks to count tokens for. System content provides instructions or context to the model about
     * how it should behave or respond. The token count will include any system content provided.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSystem} method.
     * </p>
     * 
     * @return The system content blocks to count tokens for. System content provides instructions or context to the
     *         model about how it should behave or respond. The token count will include any system content provided.
     */
    public final List<SystemContentBlock> system() {
        return system;
    }

    /**
     * <p>
     * The toolConfig of Converse input request to count tokens for. Configuration information for the tools that the
     * model can use when generating a response.
     * </p>
     * 
     * @return The toolConfig of Converse input request to count tokens for. Configuration information for the tools
     *         that the model can use when generating a response.
     */
    public final ToolConfiguration toolConfig() {
        return toolConfig;
    }

    /**
     * <p>
     * The additionalModelRequestFields of Converse input request to count tokens for. Use this field when you want to
     * pass additional parameters that the model supports.
     * </p>
     * 
     * @return The additionalModelRequestFields of Converse input request to count tokens for. Use this field when you
     *         want to pass additional parameters that the model supports.
     */
    public final Document additionalModelRequestFields() {
        return additionalModelRequestFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSystem() ? system() : null);
        hashCode = 31 * hashCode + Objects.hashCode(toolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(additionalModelRequestFields());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConverseTokensRequest)) {
            return false;
        }
        ConverseTokensRequest other = (ConverseTokensRequest) obj;
        return hasMessages() == other.hasMessages() && Objects.equals(messages(), other.messages())
                && hasSystem() == other.hasSystem() && Objects.equals(system(), other.system())
                && Objects.equals(toolConfig(), other.toolConfig())
                && Objects.equals(additionalModelRequestFields(), other.additionalModelRequestFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConverseTokensRequest").add("Messages", hasMessages() ? messages() : null)
                .add("System", hasSystem() ? system() : null).add("ToolConfig", toolConfig())
                .add("AdditionalModelRequestFields", additionalModelRequestFields()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "system":
            return Optional.ofNullable(clazz.cast(system()));
        case "toolConfig":
            return Optional.ofNullable(clazz.cast(toolConfig()));
        case "additionalModelRequestFields":
            return Optional.ofNullable(clazz.cast(additionalModelRequestFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messages", MESSAGES_FIELD);
        map.put("system", SYSTEM_FIELD);
        map.put("toolConfig", TOOL_CONFIG_FIELD);
        map.put("additionalModelRequestFields", ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConverseTokensRequest, T> g) {
        return obj -> g.apply((ConverseTokensRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConverseTokensRequest> {
        /**
         * <p>
         * An array of messages to count tokens for.
         * </p>
         * 
         * @param messages
         *        An array of messages to count tokens for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * <p>
         * An array of messages to count tokens for.
         * </p>
         * 
         * @param messages
         *        An array of messages to count tokens for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);

        /**
         * <p>
         * An array of messages to count tokens for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.Message.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrockruntime.model.Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.Message.Builder#build()} is called immediately
         * and its result is passed to {@link #messages(List<Message>)}.
         * 
         * @param messages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(java.util.Collection<Message>)
         */
        Builder messages(Consumer<Message.Builder>... messages);

        /**
         * <p>
         * The system content blocks to count tokens for. System content provides instructions or context to the model
         * about how it should behave or respond. The token count will include any system content provided.
         * </p>
         * 
         * @param system
         *        The system content blocks to count tokens for. System content provides instructions or context to the
         *        model about how it should behave or respond. The token count will include any system content provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder system(Collection<SystemContentBlock> system);

        /**
         * <p>
         * The system content blocks to count tokens for. System content provides instructions or context to the model
         * about how it should behave or respond. The token count will include any system content provided.
         * </p>
         * 
         * @param system
         *        The system content blocks to count tokens for. System content provides instructions or context to the
         *        model about how it should behave or respond. The token count will include any system content provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder system(SystemContentBlock... system);

        /**
         * <p>
         * The system content blocks to count tokens for. System content provides instructions or context to the model
         * about how it should behave or respond. The token count will include any system content provided.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlock.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #system(List<SystemContentBlock>)}.
         * 
         * @param system
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #system(java.util.Collection<SystemContentBlock>)
         */
        Builder system(Consumer<SystemContentBlock.Builder>... system);

        /**
         * <p>
         * The toolConfig of Converse input request to count tokens for. Configuration information for the tools that
         * the model can use when generating a response.
         * </p>
         * 
         * @param toolConfig
         *        The toolConfig of Converse input request to count tokens for. Configuration information for the tools
         *        that the model can use when generating a response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolConfig(ToolConfiguration toolConfig);

        /**
         * <p>
         * The toolConfig of Converse input request to count tokens for. Configuration information for the tools that
         * the model can use when generating a response.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolConfiguration.Builder} avoiding the
         * need to create one manually via {@link ToolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #toolConfig(ToolConfiguration)}.
         * 
         * @param toolConfig
         *        a consumer that will call methods on {@link ToolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolConfig(ToolConfiguration)
         */
        default Builder toolConfig(Consumer<ToolConfiguration.Builder> toolConfig) {
            return toolConfig(ToolConfiguration.builder().applyMutation(toolConfig).build());
        }

        /**
         * <p>
         * The additionalModelRequestFields of Converse input request to count tokens for. Use this field when you want
         * to pass additional parameters that the model supports.
         * </p>
         * 
         * @param additionalModelRequestFields
         *        The additionalModelRequestFields of Converse input request to count tokens for. Use this field when
         *        you want to pass additional parameters that the model supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalModelRequestFields(Document additionalModelRequestFields);
    }

    static final class BuilderImpl implements Builder {
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();

        private List<SystemContentBlock> system = DefaultSdkAutoConstructList.getInstance();

        private ToolConfiguration toolConfig;

        private Document additionalModelRequestFields;

        private BuilderImpl() {
        }

        private BuilderImpl(ConverseTokensRequest model) {
            messages(model.messages);
            system(model.system);
            toolConfig(model.toolConfig);
            additionalModelRequestFields(model.additionalModelRequestFields);
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder>... messages) {
            messages(Stream.of(messages).map(c -> Message.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SystemContentBlock.Builder> getSystem() {
            List<SystemContentBlock.Builder> result = SystemContentBlocksCopier.copyToBuilder(this.system);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystem(Collection<SystemContentBlock.BuilderImpl> system) {
            this.system = SystemContentBlocksCopier.copyFromBuilder(system);
        }

        @Override
        public final Builder system(Collection<SystemContentBlock> system) {
            this.system = SystemContentBlocksCopier.copy(system);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(SystemContentBlock... system) {
            system(Arrays.asList(system));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(Consumer<SystemContentBlock.Builder>... system) {
            system(Stream.of(system).map(c -> SystemContentBlock.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ToolConfiguration.Builder getToolConfig() {
            return toolConfig != null ? toolConfig.toBuilder() : null;
        }

        public final void setToolConfig(ToolConfiguration.BuilderImpl toolConfig) {
            this.toolConfig = toolConfig != null ? toolConfig.build() : null;
        }

        @Override
        public final Builder toolConfig(ToolConfiguration toolConfig) {
            this.toolConfig = toolConfig;
            return this;
        }

        public final Document getAdditionalModelRequestFields() {
            return additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
        }

        @Override
        public final Builder additionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
            return this;
        }

        @Override
        public ConverseTokensRequest build() {
            return new ConverseTokensRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
