/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Content block start information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentBlockStart implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentBlockStart.Builder, ContentBlockStart> {
    private static final SdkField<ToolUseBlockStart> TOOL_USE_FIELD = SdkField
            .<ToolUseBlockStart> builder(MarshallingType.SDK_POJO).memberName("toolUse")
            .getter(getter(ContentBlockStart::toolUse)).setter(setter(Builder::toolUse)).constructor(ToolUseBlockStart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUse").build()).build();

    private static final SdkField<ToolResultBlockStart> TOOL_RESULT_FIELD = SdkField
            .<ToolResultBlockStart> builder(MarshallingType.SDK_POJO).memberName("toolResult")
            .getter(getter(ContentBlockStart::toolResult)).setter(setter(Builder::toolResult))
            .constructor(ToolResultBlockStart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolResult").build()).build();

    private static final SdkField<ImageBlockStart> IMAGE_FIELD = SdkField.<ImageBlockStart> builder(MarshallingType.SDK_POJO)
            .memberName("image").getter(getter(ContentBlockStart::image)).setter(setter(Builder::image))
            .constructor(ImageBlockStart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOL_USE_FIELD,
            TOOL_RESULT_FIELD, IMAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ToolUseBlockStart toolUse;

    private final ToolResultBlockStart toolResult;

    private final ImageBlockStart image;

    private final Type type;

    private ContentBlockStart(BuilderImpl builder) {
        this.toolUse = builder.toolUse;
        this.toolResult = builder.toolResult;
        this.image = builder.image;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information about a tool that the model is requesting to use.
     * </p>
     * 
     * @return Information about a tool that the model is requesting to use.
     */
    public final ToolUseBlockStart toolUse() {
        return toolUse;
    }

    /**
     * <p>
     * The
     * </p>
     * 
     * @return The
     */
    public final ToolResultBlockStart toolResult() {
        return toolResult;
    }

    /**
     * <p>
     * The initial event indicating the start of a streaming image block.
     * </p>
     * 
     * @return The initial event indicating the start of a streaming image block.
     */
    public final ImageBlockStart image() {
        return image;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(toolUse());
        hashCode = 31 * hashCode + Objects.hashCode(toolResult());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBlockStart)) {
            return false;
        }
        ContentBlockStart other = (ContentBlockStart) obj;
        return Objects.equals(toolUse(), other.toolUse()) && Objects.equals(toolResult(), other.toolResult())
                && Objects.equals(image(), other.image());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentBlockStart").add("ToolUse", toolUse()).add("ToolResult", toolResult())
                .add("Image", image()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "toolUse":
            return Optional.ofNullable(clazz.cast(toolUse()));
        case "toolResult":
            return Optional.ofNullable(clazz.cast(toolResult()));
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #toolUse()} initialized to the given value.
     *
     * <p>
     * Information about a tool that the model is requesting to use.
     * </p>
     * 
     * @param toolUse
     *        Information about a tool that the model is requesting to use.
     */
    public static ContentBlockStart fromToolUse(ToolUseBlockStart toolUse) {
        return builder().toolUse(toolUse).build();
    }

    /**
     * Create an instance of this class with {@link #toolUse()} initialized to the given value.
     *
     * <p>
     * Information about a tool that the model is requesting to use.
     * </p>
     * 
     * @param toolUse
     *        Information about a tool that the model is requesting to use.
     */
    public static ContentBlockStart fromToolUse(Consumer<ToolUseBlockStart.Builder> toolUse) {
        ToolUseBlockStart.Builder builder = ToolUseBlockStart.builder();
        toolUse.accept(builder);
        return fromToolUse(builder.build());
    }

    /**
     * Create an instance of this class with {@link #toolResult()} initialized to the given value.
     *
     * <p>
     * The
     * </p>
     * 
     * @param toolResult
     *        The
     */
    public static ContentBlockStart fromToolResult(ToolResultBlockStart toolResult) {
        return builder().toolResult(toolResult).build();
    }

    /**
     * Create an instance of this class with {@link #toolResult()} initialized to the given value.
     *
     * <p>
     * The
     * </p>
     * 
     * @param toolResult
     *        The
     */
    public static ContentBlockStart fromToolResult(Consumer<ToolResultBlockStart.Builder> toolResult) {
        ToolResultBlockStart.Builder builder = ToolResultBlockStart.builder();
        toolResult.accept(builder);
        return fromToolResult(builder.build());
    }

    /**
     * Create an instance of this class with {@link #image()} initialized to the given value.
     *
     * <p>
     * The initial event indicating the start of a streaming image block.
     * </p>
     * 
     * @param image
     *        The initial event indicating the start of a streaming image block.
     */
    public static ContentBlockStart fromImage(ImageBlockStart image) {
        return builder().image(image).build();
    }

    /**
     * Create an instance of this class with {@link #image()} initialized to the given value.
     *
     * <p>
     * The initial event indicating the start of a streaming image block.
     * </p>
     * 
     * @param image
     *        The initial event indicating the start of a streaming image block.
     */
    public static ContentBlockStart fromImage(Consumer<ImageBlockStart.Builder> image) {
        ImageBlockStart.Builder builder = ImageBlockStart.builder();
        image.accept(builder);
        return fromImage(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("toolUse", TOOL_USE_FIELD);
        map.put("toolResult", TOOL_RESULT_FIELD);
        map.put("image", IMAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentBlockStart, T> g) {
        return obj -> g.apply((ContentBlockStart) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentBlockStart> {
        /**
         * <p>
         * Information about a tool that the model is requesting to use.
         * </p>
         * 
         * @param toolUse
         *        Information about a tool that the model is requesting to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolUse(ToolUseBlockStart toolUse);

        /**
         * <p>
         * Information about a tool that the model is requesting to use.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolUseBlockStart.Builder} avoiding the
         * need to create one manually via {@link ToolUseBlockStart#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolUseBlockStart.Builder#build()} is called immediately and its
         * result is passed to {@link #toolUse(ToolUseBlockStart)}.
         * 
         * @param toolUse
         *        a consumer that will call methods on {@link ToolUseBlockStart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolUse(ToolUseBlockStart)
         */
        default Builder toolUse(Consumer<ToolUseBlockStart.Builder> toolUse) {
            return toolUse(ToolUseBlockStart.builder().applyMutation(toolUse).build());
        }

        /**
         * <p>
         * The
         * </p>
         * 
         * @param toolResult
         *        The
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolResult(ToolResultBlockStart toolResult);

        /**
         * <p>
         * The
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolResultBlockStart.Builder} avoiding
         * the need to create one manually via {@link ToolResultBlockStart#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolResultBlockStart.Builder#build()} is called immediately and
         * its result is passed to {@link #toolResult(ToolResultBlockStart)}.
         * 
         * @param toolResult
         *        a consumer that will call methods on {@link ToolResultBlockStart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolResult(ToolResultBlockStart)
         */
        default Builder toolResult(Consumer<ToolResultBlockStart.Builder> toolResult) {
            return toolResult(ToolResultBlockStart.builder().applyMutation(toolResult).build());
        }

        /**
         * <p>
         * The initial event indicating the start of a streaming image block.
         * </p>
         * 
         * @param image
         *        The initial event indicating the start of a streaming image block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(ImageBlockStart image);

        /**
         * <p>
         * The initial event indicating the start of a streaming image block.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageBlockStart.Builder} avoiding the
         * need to create one manually via {@link ImageBlockStart#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageBlockStart.Builder#build()} is called immediately and its
         * result is passed to {@link #image(ImageBlockStart)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link ImageBlockStart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(ImageBlockStart)
         */
        default Builder image(Consumer<ImageBlockStart.Builder> image) {
            return image(ImageBlockStart.builder().applyMutation(image).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ToolUseBlockStart toolUse;

        private ToolResultBlockStart toolResult;

        private ImageBlockStart image;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ContentBlockStart model) {
            toolUse(model.toolUse);
            toolResult(model.toolResult);
            image(model.image);
        }

        public final ToolUseBlockStart.Builder getToolUse() {
            return toolUse != null ? toolUse.toBuilder() : null;
        }

        public final void setToolUse(ToolUseBlockStart.BuilderImpl toolUse) {
            Object oldValue = this.toolUse;
            this.toolUse = toolUse != null ? toolUse.build() : null;
            handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
        }

        @Override
        public final Builder toolUse(ToolUseBlockStart toolUse) {
            Object oldValue = this.toolUse;
            this.toolUse = toolUse;
            handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
            return this;
        }

        public final ToolResultBlockStart.Builder getToolResult() {
            return toolResult != null ? toolResult.toBuilder() : null;
        }

        public final void setToolResult(ToolResultBlockStart.BuilderImpl toolResult) {
            Object oldValue = this.toolResult;
            this.toolResult = toolResult != null ? toolResult.build() : null;
            handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
        }

        @Override
        public final Builder toolResult(ToolResultBlockStart toolResult) {
            Object oldValue = this.toolResult;
            this.toolResult = toolResult;
            handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
            return this;
        }

        public final ImageBlockStart.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(ImageBlockStart.BuilderImpl image) {
            Object oldValue = this.image;
            this.image = image != null ? image.build() : null;
            handleUnionValueChange(Type.IMAGE, oldValue, this.image);
        }

        @Override
        public final Builder image(ImageBlockStart image) {
            Object oldValue = this.image;
            this.image = image;
            handleUnionValueChange(Type.IMAGE, oldValue, this.image);
            return this;
        }

        @Override
        public ContentBlockStart build() {
            return new ContentBlockStart(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ContentBlockStart#type()
     */
    public enum Type {
        TOOL_USE,

        TOOL_RESULT,

        IMAGE,

        UNKNOWN_TO_SDK_VERSION
    }
}
