/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the specific guardrail that was applied during this assessment, including its identifier, version, ARN,
 * origin, and ownership information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppliedGuardrailDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AppliedGuardrailDetails.Builder, AppliedGuardrailDetails> {
    private static final SdkField<String> GUARDRAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailId").getter(getter(AppliedGuardrailDetails::guardrailId)).setter(setter(Builder::guardrailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailId").build()).build();

    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailVersion").getter(getter(AppliedGuardrailDetails::guardrailVersion))
            .setter(setter(Builder::guardrailVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailVersion").build()).build();

    private static final SdkField<String> GUARDRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailArn").getter(getter(AppliedGuardrailDetails::guardrailArn))
            .setter(setter(Builder::guardrailArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailArn").build()).build();

    private static final SdkField<List<String>> GUARDRAIL_ORIGIN_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("guardrailOrigin")
            .getter(getter(AppliedGuardrailDetails::guardrailOriginAsStrings))
            .setter(setter(Builder::guardrailOriginWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailOrigin").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GUARDRAIL_OWNERSHIP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailOwnership").getter(getter(AppliedGuardrailDetails::guardrailOwnershipAsString))
            .setter(setter(Builder::guardrailOwnership))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailOwnership").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_ID_FIELD,
            GUARDRAIL_VERSION_FIELD, GUARDRAIL_ARN_FIELD, GUARDRAIL_ORIGIN_FIELD, GUARDRAIL_OWNERSHIP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String guardrailId;

    private final String guardrailVersion;

    private final String guardrailArn;

    private final List<String> guardrailOrigin;

    private final String guardrailOwnership;

    private AppliedGuardrailDetails(BuilderImpl builder) {
        this.guardrailId = builder.guardrailId;
        this.guardrailVersion = builder.guardrailVersion;
        this.guardrailArn = builder.guardrailArn;
        this.guardrailOrigin = builder.guardrailOrigin;
        this.guardrailOwnership = builder.guardrailOwnership;
    }

    /**
     * <p>
     * The unique ID of the guardrail that was applied.
     * </p>
     * 
     * @return The unique ID of the guardrail that was applied.
     */
    public final String guardrailId() {
        return guardrailId;
    }

    /**
     * <p>
     * The version of the guardrail that was applied.
     * </p>
     * 
     * @return The version of the guardrail that was applied.
     */
    public final String guardrailVersion() {
        return guardrailVersion;
    }

    /**
     * <p>
     * The ARN of the guardrail that was applied.
     * </p>
     * 
     * @return The ARN of the guardrail that was applied.
     */
    public final String guardrailArn() {
        return guardrailArn;
    }

    /**
     * <p>
     * The origin of how the guardrail was applied. This can be either requested at the API level or enforced at the
     * account or organization level as a default guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGuardrailOrigin} method.
     * </p>
     * 
     * @return The origin of how the guardrail was applied. This can be either requested at the API level or enforced at
     *         the account or organization level as a default guardrail.
     */
    public final List<GuardrailOrigin> guardrailOrigin() {
        return GuardrailOriginListCopier.copyStringToEnum(guardrailOrigin);
    }

    /**
     * For responses, this returns true if the service returned a value for the GuardrailOrigin property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGuardrailOrigin() {
        return guardrailOrigin != null && !(guardrailOrigin instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The origin of how the guardrail was applied. This can be either requested at the API level or enforced at the
     * account or organization level as a default guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGuardrailOrigin} method.
     * </p>
     * 
     * @return The origin of how the guardrail was applied. This can be either requested at the API level or enforced at
     *         the account or organization level as a default guardrail.
     */
    public final List<String> guardrailOriginAsStrings() {
        return guardrailOrigin;
    }

    /**
     * <p>
     * The ownership type of the guardrail, indicating whether it is owned by the requesting account or is a
     * cross-account guardrail shared from another AWS account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #guardrailOwnership} will return {@link GuardrailOwnership#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #guardrailOwnershipAsString}.
     * </p>
     * 
     * @return The ownership type of the guardrail, indicating whether it is owned by the requesting account or is a
     *         cross-account guardrail shared from another AWS account.
     * @see GuardrailOwnership
     */
    public final GuardrailOwnership guardrailOwnership() {
        return GuardrailOwnership.fromValue(guardrailOwnership);
    }

    /**
     * <p>
     * The ownership type of the guardrail, indicating whether it is owned by the requesting account or is a
     * cross-account guardrail shared from another AWS account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #guardrailOwnership} will return {@link GuardrailOwnership#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #guardrailOwnershipAsString}.
     * </p>
     * 
     * @return The ownership type of the guardrail, indicating whether it is owned by the requesting account or is a
     *         cross-account guardrail shared from another AWS account.
     * @see GuardrailOwnership
     */
    public final String guardrailOwnershipAsString() {
        return guardrailOwnership;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(guardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailVersion());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasGuardrailOrigin() ? guardrailOriginAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(guardrailOwnershipAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppliedGuardrailDetails)) {
            return false;
        }
        AppliedGuardrailDetails other = (AppliedGuardrailDetails) obj;
        return Objects.equals(guardrailId(), other.guardrailId()) && Objects.equals(guardrailVersion(), other.guardrailVersion())
                && Objects.equals(guardrailArn(), other.guardrailArn()) && hasGuardrailOrigin() == other.hasGuardrailOrigin()
                && Objects.equals(guardrailOriginAsStrings(), other.guardrailOriginAsStrings())
                && Objects.equals(guardrailOwnershipAsString(), other.guardrailOwnershipAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppliedGuardrailDetails").add("GuardrailId", guardrailId())
                .add("GuardrailVersion", guardrailVersion()).add("GuardrailArn", guardrailArn())
                .add("GuardrailOrigin", hasGuardrailOrigin() ? guardrailOriginAsStrings() : null)
                .add("GuardrailOwnership", guardrailOwnershipAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrailId":
            return Optional.ofNullable(clazz.cast(guardrailId()));
        case "guardrailVersion":
            return Optional.ofNullable(clazz.cast(guardrailVersion()));
        case "guardrailArn":
            return Optional.ofNullable(clazz.cast(guardrailArn()));
        case "guardrailOrigin":
            return Optional.ofNullable(clazz.cast(guardrailOriginAsStrings()));
        case "guardrailOwnership":
            return Optional.ofNullable(clazz.cast(guardrailOwnershipAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("guardrailId", GUARDRAIL_ID_FIELD);
        map.put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
        map.put("guardrailArn", GUARDRAIL_ARN_FIELD);
        map.put("guardrailOrigin", GUARDRAIL_ORIGIN_FIELD);
        map.put("guardrailOwnership", GUARDRAIL_OWNERSHIP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppliedGuardrailDetails, T> g) {
        return obj -> g.apply((AppliedGuardrailDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppliedGuardrailDetails> {
        /**
         * <p>
         * The unique ID of the guardrail that was applied.
         * </p>
         * 
         * @param guardrailId
         *        The unique ID of the guardrail that was applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailId(String guardrailId);

        /**
         * <p>
         * The version of the guardrail that was applied.
         * </p>
         * 
         * @param guardrailVersion
         *        The version of the guardrail that was applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailVersion(String guardrailVersion);

        /**
         * <p>
         * The ARN of the guardrail that was applied.
         * </p>
         * 
         * @param guardrailArn
         *        The ARN of the guardrail that was applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailArn(String guardrailArn);

        /**
         * <p>
         * The origin of how the guardrail was applied. This can be either requested at the API level or enforced at the
         * account or organization level as a default guardrail.
         * </p>
         * 
         * @param guardrailOrigin
         *        The origin of how the guardrail was applied. This can be either requested at the API level or enforced
         *        at the account or organization level as a default guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailOriginWithStrings(Collection<String> guardrailOrigin);

        /**
         * <p>
         * The origin of how the guardrail was applied. This can be either requested at the API level or enforced at the
         * account or organization level as a default guardrail.
         * </p>
         * 
         * @param guardrailOrigin
         *        The origin of how the guardrail was applied. This can be either requested at the API level or enforced
         *        at the account or organization level as a default guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailOriginWithStrings(String... guardrailOrigin);

        /**
         * <p>
         * The origin of how the guardrail was applied. This can be either requested at the API level or enforced at the
         * account or organization level as a default guardrail.
         * </p>
         * 
         * @param guardrailOrigin
         *        The origin of how the guardrail was applied. This can be either requested at the API level or enforced
         *        at the account or organization level as a default guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailOrigin(Collection<GuardrailOrigin> guardrailOrigin);

        /**
         * <p>
         * The origin of how the guardrail was applied. This can be either requested at the API level or enforced at the
         * account or organization level as a default guardrail.
         * </p>
         * 
         * @param guardrailOrigin
         *        The origin of how the guardrail was applied. This can be either requested at the API level or enforced
         *        at the account or organization level as a default guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailOrigin(GuardrailOrigin... guardrailOrigin);

        /**
         * <p>
         * The ownership type of the guardrail, indicating whether it is owned by the requesting account or is a
         * cross-account guardrail shared from another AWS account.
         * </p>
         * 
         * @param guardrailOwnership
         *        The ownership type of the guardrail, indicating whether it is owned by the requesting account or is a
         *        cross-account guardrail shared from another AWS account.
         * @see GuardrailOwnership
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailOwnership
         */
        Builder guardrailOwnership(String guardrailOwnership);

        /**
         * <p>
         * The ownership type of the guardrail, indicating whether it is owned by the requesting account or is a
         * cross-account guardrail shared from another AWS account.
         * </p>
         * 
         * @param guardrailOwnership
         *        The ownership type of the guardrail, indicating whether it is owned by the requesting account or is a
         *        cross-account guardrail shared from another AWS account.
         * @see GuardrailOwnership
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailOwnership
         */
        Builder guardrailOwnership(GuardrailOwnership guardrailOwnership);
    }

    static final class BuilderImpl implements Builder {
        private String guardrailId;

        private String guardrailVersion;

        private String guardrailArn;

        private List<String> guardrailOrigin = DefaultSdkAutoConstructList.getInstance();

        private String guardrailOwnership;

        private BuilderImpl() {
        }

        private BuilderImpl(AppliedGuardrailDetails model) {
            guardrailId(model.guardrailId);
            guardrailVersion(model.guardrailVersion);
            guardrailArn(model.guardrailArn);
            guardrailOriginWithStrings(model.guardrailOrigin);
            guardrailOwnership(model.guardrailOwnership);
        }

        public final String getGuardrailId() {
            return guardrailId;
        }

        public final void setGuardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
        }

        @Override
        public final Builder guardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
            return this;
        }

        public final String getGuardrailVersion() {
            return guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public final String getGuardrailArn() {
            return guardrailArn;
        }

        public final void setGuardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
        }

        @Override
        public final Builder guardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
            return this;
        }

        public final Collection<String> getGuardrailOrigin() {
            if (guardrailOrigin instanceof SdkAutoConstructList) {
                return null;
            }
            return guardrailOrigin;
        }

        public final void setGuardrailOrigin(Collection<String> guardrailOrigin) {
            this.guardrailOrigin = GuardrailOriginListCopier.copy(guardrailOrigin);
        }

        @Override
        public final Builder guardrailOriginWithStrings(Collection<String> guardrailOrigin) {
            this.guardrailOrigin = GuardrailOriginListCopier.copy(guardrailOrigin);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailOriginWithStrings(String... guardrailOrigin) {
            guardrailOriginWithStrings(Arrays.asList(guardrailOrigin));
            return this;
        }

        @Override
        public final Builder guardrailOrigin(Collection<GuardrailOrigin> guardrailOrigin) {
            this.guardrailOrigin = GuardrailOriginListCopier.copyEnumToString(guardrailOrigin);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailOrigin(GuardrailOrigin... guardrailOrigin) {
            guardrailOrigin(Arrays.asList(guardrailOrigin));
            return this;
        }

        public final String getGuardrailOwnership() {
            return guardrailOwnership;
        }

        public final void setGuardrailOwnership(String guardrailOwnership) {
            this.guardrailOwnership = guardrailOwnership;
        }

        @Override
        public final Builder guardrailOwnership(String guardrailOwnership) {
            this.guardrailOwnership = guardrailOwnership;
            return this;
        }

        @Override
        public final Builder guardrailOwnership(GuardrailOwnership guardrailOwnership) {
            this.guardrailOwnership(guardrailOwnership == null ? null : guardrailOwnership.toString());
            return this;
        }

        @Override
        public AppliedGuardrailDetails build() {
            return new AppliedGuardrailDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
