/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.Tool;
import software.amazon.awssdk.services.bedrockruntime.model.ToolChoice;
import software.amazon.awssdk.services.bedrockruntime.model.ToolConfigurationToolsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToolConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToolConfiguration> {
    private static final SdkField<List<Tool>> TOOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tools").getter(ToolConfiguration.getter(ToolConfiguration::tools)).setter(ToolConfiguration.setter(Builder::tools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ToolChoice> TOOL_CHOICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolChoice").getter(ToolConfiguration.getter(ToolConfiguration::toolChoice)).setter(ToolConfiguration.setter(Builder::toolChoice)).constructor(ToolChoice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolChoice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOLS_FIELD, TOOL_CHOICE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ToolConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Tool> tools;
    private final ToolChoice toolChoice;

    private ToolConfiguration(BuilderImpl builder) {
        this.tools = builder.tools;
        this.toolChoice = builder.toolChoice;
    }

    public final boolean hasTools() {
        return this.tools != null && !(this.tools instanceof SdkAutoConstructList);
    }

    public final List<Tool> tools() {
        return this.tools;
    }

    public final ToolChoice toolChoice() {
        return this.toolChoice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTools() ? this.tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.toolChoice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolConfiguration)) {
            return false;
        }
        ToolConfiguration other = (ToolConfiguration)obj;
        return this.hasTools() == other.hasTools() && Objects.equals(this.tools(), other.tools()) && Objects.equals(this.toolChoice(), other.toolChoice());
    }

    public final String toString() {
        return ToString.builder((String)"ToolConfiguration").add("Tools", this.hasTools() ? this.tools() : null).add("ToolChoice", (Object)this.toolChoice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tools": {
                return Optional.ofNullable(clazz.cast(this.tools()));
            }
            case "toolChoice": {
                return Optional.ofNullable(clazz.cast(this.toolChoice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tools", TOOLS_FIELD);
        map.put("toolChoice", TOOL_CHOICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolConfiguration, T> g) {
        return obj -> g.apply((ToolConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Tool> tools = DefaultSdkAutoConstructList.getInstance();
        private ToolChoice toolChoice;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolConfiguration model) {
            this.tools(model.tools);
            this.toolChoice(model.toolChoice);
        }

        public final List<Tool.Builder> getTools() {
            List<Tool.Builder> result = ToolConfigurationToolsListCopier.copyToBuilder(this.tools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTools(Collection<Tool.BuilderImpl> tools) {
            this.tools = ToolConfigurationToolsListCopier.copyFromBuilder(tools);
        }

        @Override
        public final Builder tools(Collection<Tool> tools) {
            this.tools = ToolConfigurationToolsListCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Tool ... tools) {
            this.tools(Arrays.asList(tools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Consumer<Tool.Builder> ... tools) {
            this.tools(Stream.of(tools).map(c -> (Tool)((Tool.Builder)Tool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ToolChoice.Builder getToolChoice() {
            return this.toolChoice != null ? this.toolChoice.toBuilder() : null;
        }

        public final void setToolChoice(ToolChoice.BuilderImpl toolChoice) {
            this.toolChoice = toolChoice != null ? toolChoice.build() : null;
        }

        @Override
        public final Builder toolChoice(ToolChoice toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public ToolConfiguration build() {
            return new ToolConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToolConfiguration> {
        public Builder tools(Collection<Tool> var1);

        public Builder tools(Tool ... var1);

        public Builder tools(Consumer<Tool.Builder> ... var1);

        public Builder toolChoice(ToolChoice var1);

        default public Builder toolChoice(Consumer<ToolChoice.Builder> toolChoice) {
            return this.toolChoice((ToolChoice)((ToolChoice.Builder)ToolChoice.builder().applyMutation(toolChoice)).build());
        }
    }
}

