/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultInvokeModelWithBidirectionalStreamVisitorBuilder implements
        InvokeModelWithBidirectionalStreamResponseHandler.Visitor.Builder {
    private Consumer<InvokeModelWithBidirectionalStreamOutput> onDefault;

    private Consumer<BidirectionalOutputPayloadPart> onChunk;

    @Override
    public InvokeModelWithBidirectionalStreamResponseHandler.Visitor.Builder onDefault(
            Consumer<InvokeModelWithBidirectionalStreamOutput> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public InvokeModelWithBidirectionalStreamResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public InvokeModelWithBidirectionalStreamResponseHandler.Visitor.Builder onChunk(Consumer<BidirectionalOutputPayloadPart> c) {
        this.onChunk = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements InvokeModelWithBidirectionalStreamResponseHandler.Visitor {
        private final Consumer<InvokeModelWithBidirectionalStreamOutput> onDefault;

        private final Consumer<BidirectionalOutputPayloadPart> onChunk;

        VisitorFromBuilder(DefaultInvokeModelWithBidirectionalStreamVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : InvokeModelWithBidirectionalStreamResponseHandler.Visitor.super::visitDefault;
            this.onChunk = builder.onChunk != null ? builder.onChunk
                    : InvokeModelWithBidirectionalStreamResponseHandler.Visitor.super::visitChunk;
        }

        @Override
        public void visitDefault(InvokeModelWithBidirectionalStreamOutput event) {
            onDefault.accept(event);
        }

        @Override
        public void visitChunk(BidirectionalOutputPayloadPart event) {
            onChunk.accept(event);
        }
    }
}
