/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.ReasoningTextBlock;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReasoningContentBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReasoningContentBlock> {
    private static final SdkField<ReasoningTextBlock> REASONING_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reasoningText").getter(ReasoningContentBlock.getter(ReasoningContentBlock::reasoningText)).setter(ReasoningContentBlock.setter(Builder::reasoningText)).constructor(ReasoningTextBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasoningText").build()}).build();
    private static final SdkField<SdkBytes> REDACTED_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("redactedContent").getter(ReasoningContentBlock.getter(ReasoningContentBlock::redactedContent)).setter(ReasoningContentBlock.setter(Builder::redactedContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redactedContent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASONING_TEXT_FIELD, REDACTED_CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReasoningContentBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ReasoningTextBlock reasoningText;
    private final SdkBytes redactedContent;
    private final Type type;

    private ReasoningContentBlock(BuilderImpl builder) {
        this.reasoningText = builder.reasoningText;
        this.redactedContent = builder.redactedContent;
        this.type = builder.type;
    }

    public final ReasoningTextBlock reasoningText() {
        return this.reasoningText;
    }

    public final SdkBytes redactedContent() {
        return this.redactedContent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reasoningText());
        hashCode = 31 * hashCode + Objects.hashCode(this.redactedContent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReasoningContentBlock)) {
            return false;
        }
        ReasoningContentBlock other = (ReasoningContentBlock)obj;
        return Objects.equals(this.reasoningText(), other.reasoningText()) && Objects.equals(this.redactedContent(), other.redactedContent());
    }

    public final String toString() {
        return ToString.builder((String)"ReasoningContentBlock").add("ReasoningText", (Object)(this.reasoningText() == null ? null : "*** Sensitive Data Redacted ***")).add("RedactedContent", (Object)this.redactedContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reasoningText": {
                return Optional.ofNullable(clazz.cast(this.reasoningText()));
            }
            case "redactedContent": {
                return Optional.ofNullable(clazz.cast(this.redactedContent()));
            }
        }
        return Optional.empty();
    }

    public static ReasoningContentBlock fromReasoningText(ReasoningTextBlock reasoningText) {
        return (ReasoningContentBlock)ReasoningContentBlock.builder().reasoningText(reasoningText).build();
    }

    public static ReasoningContentBlock fromReasoningText(Consumer<ReasoningTextBlock.Builder> reasoningText) {
        ReasoningTextBlock.Builder builder = ReasoningTextBlock.builder();
        reasoningText.accept(builder);
        return ReasoningContentBlock.fromReasoningText((ReasoningTextBlock)builder.build());
    }

    public static ReasoningContentBlock fromRedactedContent(SdkBytes redactedContent) {
        return (ReasoningContentBlock)ReasoningContentBlock.builder().redactedContent(redactedContent).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reasoningText", REASONING_TEXT_FIELD);
        map.put("redactedContent", REDACTED_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReasoningContentBlock, T> g) {
        return obj -> g.apply((ReasoningContentBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        REASONING_TEXT,
        REDACTED_CONTENT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ReasoningTextBlock reasoningText;
        private SdkBytes redactedContent;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReasoningContentBlock model) {
            this.reasoningText(model.reasoningText);
            this.redactedContent(model.redactedContent);
        }

        public final ReasoningTextBlock.Builder getReasoningText() {
            return this.reasoningText != null ? this.reasoningText.toBuilder() : null;
        }

        public final void setReasoningText(ReasoningTextBlock.BuilderImpl reasoningText) {
            ReasoningTextBlock oldValue = this.reasoningText;
            this.reasoningText = reasoningText != null ? reasoningText.build() : null;
            this.handleUnionValueChange(Type.REASONING_TEXT, oldValue, this.reasoningText);
        }

        @Override
        public final Builder reasoningText(ReasoningTextBlock reasoningText) {
            ReasoningTextBlock oldValue = this.reasoningText;
            this.reasoningText = reasoningText;
            this.handleUnionValueChange(Type.REASONING_TEXT, oldValue, this.reasoningText);
            return this;
        }

        public final ByteBuffer getRedactedContent() {
            return this.redactedContent == null ? null : this.redactedContent.asByteBuffer();
        }

        public final void setRedactedContent(ByteBuffer redactedContent) {
            this.redactedContent(redactedContent == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)redactedContent));
        }

        @Override
        public final Builder redactedContent(SdkBytes redactedContent) {
            SdkBytes oldValue = this.redactedContent;
            this.redactedContent = redactedContent;
            this.handleUnionValueChange(Type.REDACTED_CONTENT, oldValue, this.redactedContent);
            return this;
        }

        public ReasoningContentBlock build() {
            return new ReasoningContentBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReasoningContentBlock> {
        public Builder reasoningText(ReasoningTextBlock var1);

        default public Builder reasoningText(Consumer<ReasoningTextBlock.Builder> reasoningText) {
            return this.reasoningText((ReasoningTextBlock)((ReasoningTextBlock.Builder)ReasoningTextBlock.builder().applyMutation(reasoningText)).build());
        }

        public Builder redactedContent(SdkBytes var1);
    }
}

