/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentQualifier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentQualifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailTextBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailTextBlock> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(GuardrailTextBlock.getter(GuardrailTextBlock::text)).setter(GuardrailTextBlock.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<List<String>> QUALIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("qualifiers").getter(GuardrailTextBlock.getter(GuardrailTextBlock::qualifiersAsStrings)).setter(GuardrailTextBlock.setter(Builder::qualifiersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, QUALIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailTextBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String text;
    private final List<String> qualifiers;

    private GuardrailTextBlock(BuilderImpl builder) {
        this.text = builder.text;
        this.qualifiers = builder.qualifiers;
    }

    public final String text() {
        return this.text;
    }

    public final List<GuardrailContentQualifier> qualifiers() {
        return GuardrailContentQualifierListCopier.copyStringToEnum(this.qualifiers);
    }

    public final boolean hasQualifiers() {
        return this.qualifiers != null && !(this.qualifiers instanceof SdkAutoConstructList);
    }

    public final List<String> qualifiersAsStrings() {
        return this.qualifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQualifiers() ? this.qualifiersAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTextBlock)) {
            return false;
        }
        GuardrailTextBlock other = (GuardrailTextBlock)obj;
        return Objects.equals(this.text(), other.text()) && this.hasQualifiers() == other.hasQualifiers() && Objects.equals(this.qualifiersAsStrings(), other.qualifiersAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailTextBlock").add("Text", (Object)this.text()).add("Qualifiers", this.hasQualifiers() ? this.qualifiersAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "qualifiers": {
                return Optional.ofNullable(clazz.cast(this.qualifiersAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", TEXT_FIELD);
        map.put("qualifiers", QUALIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTextBlock, T> g) {
        return obj -> g.apply((GuardrailTextBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private List<String> qualifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTextBlock model) {
            this.text(model.text);
            this.qualifiersWithStrings(model.qualifiers);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final Collection<String> getQualifiers() {
            if (this.qualifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.qualifiers;
        }

        public final void setQualifiers(Collection<String> qualifiers) {
            this.qualifiers = GuardrailContentQualifierListCopier.copy(qualifiers);
        }

        @Override
        public final Builder qualifiersWithStrings(Collection<String> qualifiers) {
            this.qualifiers = GuardrailContentQualifierListCopier.copy(qualifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualifiersWithStrings(String ... qualifiers) {
            this.qualifiersWithStrings(Arrays.asList(qualifiers));
            return this;
        }

        @Override
        public final Builder qualifiers(Collection<GuardrailContentQualifier> qualifiers) {
            this.qualifiers = GuardrailContentQualifierListCopier.copyEnumToString(qualifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualifiers(GuardrailContentQualifier ... qualifiers) {
            this.qualifiers(Arrays.asList(qualifiers));
            return this;
        }

        public GuardrailTextBlock build() {
            return new GuardrailTextBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailTextBlock> {
        public Builder text(String var1);

        public Builder qualifiersWithStrings(Collection<String> var1);

        public Builder qualifiersWithStrings(String ... var1);

        public Builder qualifiers(Collection<GuardrailContentQualifier> var1);

        public Builder qualifiers(GuardrailContentQualifier ... var1);
    }
}

