/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The policy assessment details for the guardrails contextual grounding filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailContextualGroundingPolicyAssessment implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailContextualGroundingPolicyAssessment.Builder, GuardrailContextualGroundingPolicyAssessment> {
    private static final SdkField<List<GuardrailContextualGroundingFilter>> FILTERS_FIELD = SdkField
            .<List<GuardrailContextualGroundingFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(GuardrailContextualGroundingPolicyAssessment::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailContextualGroundingFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailContextualGroundingFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GuardrailContextualGroundingFilter> filters;

    private GuardrailContextualGroundingPolicyAssessment(BuilderImpl builder) {
        this.filters = builder.filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter details for the guardrails contextual grounding filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filter details for the guardrails contextual grounding filter.
     */
    public final List<GuardrailContextualGroundingFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContextualGroundingPolicyAssessment)) {
            return false;
        }
        GuardrailContextualGroundingPolicyAssessment other = (GuardrailContextualGroundingPolicyAssessment) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailContextualGroundingPolicyAssessment").add("Filters", hasFilters() ? filters() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContextualGroundingPolicyAssessment, T> g) {
        return obj -> g.apply((GuardrailContextualGroundingPolicyAssessment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailContextualGroundingPolicyAssessment> {
        /**
         * <p>
         * The filter details for the guardrails contextual grounding filter.
         * </p>
         * 
         * @param filters
         *        The filter details for the guardrails contextual grounding filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<GuardrailContextualGroundingFilter> filters);

        /**
         * <p>
         * The filter details for the guardrails contextual grounding filter.
         * </p>
         * 
         * @param filters
         *        The filter details for the guardrails contextual grounding filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(GuardrailContextualGroundingFilter... filters);

        /**
         * <p>
         * The filter details for the guardrails contextual grounding filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailContextualGroundingFilter.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailContextualGroundingFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailContextualGroundingFilter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<GuardrailContextualGroundingFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailContextualGroundingFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<GuardrailContextualGroundingFilter>)
         */
        Builder filters(Consumer<GuardrailContextualGroundingFilter.Builder>... filters);
    }

    static final class BuilderImpl implements Builder {
        private List<GuardrailContextualGroundingFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContextualGroundingPolicyAssessment model) {
            filters(model.filters);
        }

        public final List<GuardrailContextualGroundingFilter.Builder> getFilters() {
            List<GuardrailContextualGroundingFilter.Builder> result = GuardrailContextualGroundingFiltersCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<GuardrailContextualGroundingFilter.BuilderImpl> filters) {
            this.filters = GuardrailContextualGroundingFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<GuardrailContextualGroundingFilter> filters) {
            this.filters = GuardrailContextualGroundingFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(GuardrailContextualGroundingFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<GuardrailContextualGroundingFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> GuardrailContextualGroundingFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GuardrailContextualGroundingPolicyAssessment build() {
            return new GuardrailContextualGroundingPolicyAssessment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
