/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for a guardrail that you use with the <a>ConverseStream</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailStreamConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailStreamConfiguration.Builder, GuardrailStreamConfiguration> {
    private static final SdkField<String> GUARDRAIL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailIdentifier").getter(getter(GuardrailStreamConfiguration::guardrailIdentifier))
            .setter(setter(Builder::guardrailIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailIdentifier").build())
            .build();

    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailVersion").getter(getter(GuardrailStreamConfiguration::guardrailVersion))
            .setter(setter(Builder::guardrailVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailVersion").build()).build();

    private static final SdkField<String> TRACE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("trace")
            .getter(getter(GuardrailStreamConfiguration::traceAsString)).setter(setter(Builder::trace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trace").build()).build();

    private static final SdkField<String> STREAM_PROCESSING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamProcessingMode").getter(getter(GuardrailStreamConfiguration::streamProcessingModeAsString))
            .setter(setter(Builder::streamProcessingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamProcessingMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_IDENTIFIER_FIELD,
            GUARDRAIL_VERSION_FIELD, TRACE_FIELD, STREAM_PROCESSING_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String guardrailIdentifier;

    private final String guardrailVersion;

    private final String trace;

    private final String streamProcessingMode;

    private GuardrailStreamConfiguration(BuilderImpl builder) {
        this.guardrailIdentifier = builder.guardrailIdentifier;
        this.guardrailVersion = builder.guardrailVersion;
        this.trace = builder.trace;
        this.streamProcessingMode = builder.streamProcessingMode;
    }

    /**
     * <p>
     * The identifier for the guardrail.
     * </p>
     * 
     * @return The identifier for the guardrail.
     */
    public final String guardrailIdentifier() {
        return guardrailIdentifier;
    }

    /**
     * <p>
     * The version of the guardrail.
     * </p>
     * 
     * @return The version of the guardrail.
     */
    public final String guardrailVersion() {
        return guardrailVersion;
    }

    /**
     * <p>
     * The trace behavior for the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trace} will return
     * {@link GuardrailTrace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traceAsString}.
     * </p>
     * 
     * @return The trace behavior for the guardrail.
     * @see GuardrailTrace
     */
    public final GuardrailTrace trace() {
        return GuardrailTrace.fromValue(trace);
    }

    /**
     * <p>
     * The trace behavior for the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trace} will return
     * {@link GuardrailTrace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traceAsString}.
     * </p>
     * 
     * @return The trace behavior for the guardrail.
     * @see GuardrailTrace
     */
    public final String traceAsString() {
        return trace;
    }

    /**
     * <p>
     * The processing mode.
     * </p>
     * <p>
     * The processing mode. For more information, see <i>Configure streaming response behavior</i> in the <i>Amazon
     * Bedrock User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamProcessingMode} will return {@link GuardrailStreamProcessingMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #streamProcessingModeAsString}.
     * </p>
     * 
     * @return The processing mode. </p>
     *         <p>
     *         The processing mode. For more information, see <i>Configure streaming response behavior</i> in the
     *         <i>Amazon Bedrock User Guide</i>.
     * @see GuardrailStreamProcessingMode
     */
    public final GuardrailStreamProcessingMode streamProcessingMode() {
        return GuardrailStreamProcessingMode.fromValue(streamProcessingMode);
    }

    /**
     * <p>
     * The processing mode.
     * </p>
     * <p>
     * The processing mode. For more information, see <i>Configure streaming response behavior</i> in the <i>Amazon
     * Bedrock User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamProcessingMode} will return {@link GuardrailStreamProcessingMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #streamProcessingModeAsString}.
     * </p>
     * 
     * @return The processing mode. </p>
     *         <p>
     *         The processing mode. For more information, see <i>Configure streaming response behavior</i> in the
     *         <i>Amazon Bedrock User Guide</i>.
     * @see GuardrailStreamProcessingMode
     */
    public final String streamProcessingModeAsString() {
        return streamProcessingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(guardrailIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailVersion());
        hashCode = 31 * hashCode + Objects.hashCode(traceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamProcessingModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailStreamConfiguration)) {
            return false;
        }
        GuardrailStreamConfiguration other = (GuardrailStreamConfiguration) obj;
        return Objects.equals(guardrailIdentifier(), other.guardrailIdentifier())
                && Objects.equals(guardrailVersion(), other.guardrailVersion())
                && Objects.equals(traceAsString(), other.traceAsString())
                && Objects.equals(streamProcessingModeAsString(), other.streamProcessingModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailStreamConfiguration").add("GuardrailIdentifier", guardrailIdentifier())
                .add("GuardrailVersion", guardrailVersion()).add("Trace", traceAsString())
                .add("StreamProcessingMode", streamProcessingModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrailIdentifier":
            return Optional.ofNullable(clazz.cast(guardrailIdentifier()));
        case "guardrailVersion":
            return Optional.ofNullable(clazz.cast(guardrailVersion()));
        case "trace":
            return Optional.ofNullable(clazz.cast(traceAsString()));
        case "streamProcessingMode":
            return Optional.ofNullable(clazz.cast(streamProcessingModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("guardrailIdentifier", GUARDRAIL_IDENTIFIER_FIELD);
        map.put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
        map.put("trace", TRACE_FIELD);
        map.put("streamProcessingMode", STREAM_PROCESSING_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailStreamConfiguration, T> g) {
        return obj -> g.apply((GuardrailStreamConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailStreamConfiguration> {
        /**
         * <p>
         * The identifier for the guardrail.
         * </p>
         * 
         * @param guardrailIdentifier
         *        The identifier for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailIdentifier(String guardrailIdentifier);

        /**
         * <p>
         * The version of the guardrail.
         * </p>
         * 
         * @param guardrailVersion
         *        The version of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailVersion(String guardrailVersion);

        /**
         * <p>
         * The trace behavior for the guardrail.
         * </p>
         * 
         * @param trace
         *        The trace behavior for the guardrail.
         * @see GuardrailTrace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailTrace
         */
        Builder trace(String trace);

        /**
         * <p>
         * The trace behavior for the guardrail.
         * </p>
         * 
         * @param trace
         *        The trace behavior for the guardrail.
         * @see GuardrailTrace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailTrace
         */
        Builder trace(GuardrailTrace trace);

        /**
         * <p>
         * The processing mode.
         * </p>
         * <p>
         * The processing mode. For more information, see <i>Configure streaming response behavior</i> in the <i>Amazon
         * Bedrock User Guide</i>.
         * </p>
         * 
         * @param streamProcessingMode
         *        The processing mode. </p>
         *        <p>
         *        The processing mode. For more information, see <i>Configure streaming response behavior</i> in the
         *        <i>Amazon Bedrock User Guide</i>.
         * @see GuardrailStreamProcessingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailStreamProcessingMode
         */
        Builder streamProcessingMode(String streamProcessingMode);

        /**
         * <p>
         * The processing mode.
         * </p>
         * <p>
         * The processing mode. For more information, see <i>Configure streaming response behavior</i> in the <i>Amazon
         * Bedrock User Guide</i>.
         * </p>
         * 
         * @param streamProcessingMode
         *        The processing mode. </p>
         *        <p>
         *        The processing mode. For more information, see <i>Configure streaming response behavior</i> in the
         *        <i>Amazon Bedrock User Guide</i>.
         * @see GuardrailStreamProcessingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailStreamProcessingMode
         */
        Builder streamProcessingMode(GuardrailStreamProcessingMode streamProcessingMode);
    }

    static final class BuilderImpl implements Builder {
        private String guardrailIdentifier;

        private String guardrailVersion;

        private String trace;

        private String streamProcessingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailStreamConfiguration model) {
            guardrailIdentifier(model.guardrailIdentifier);
            guardrailVersion(model.guardrailVersion);
            trace(model.trace);
            streamProcessingMode(model.streamProcessingMode);
        }

        public final String getGuardrailIdentifier() {
            return guardrailIdentifier;
        }

        public final void setGuardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
        }

        @Override
        public final Builder guardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
            return this;
        }

        public final String getGuardrailVersion() {
            return guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public final String getTrace() {
            return trace;
        }

        public final void setTrace(String trace) {
            this.trace = trace;
        }

        @Override
        public final Builder trace(String trace) {
            this.trace = trace;
            return this;
        }

        @Override
        public final Builder trace(GuardrailTrace trace) {
            this.trace(trace == null ? null : trace.toString());
            return this;
        }

        public final String getStreamProcessingMode() {
            return streamProcessingMode;
        }

        public final void setStreamProcessingMode(String streamProcessingMode) {
            this.streamProcessingMode = streamProcessingMode;
        }

        @Override
        public final Builder streamProcessingMode(String streamProcessingMode) {
            this.streamProcessingMode = streamProcessingMode;
            return this;
        }

        @Override
        public final Builder streamProcessingMode(GuardrailStreamProcessingMode streamProcessingMode) {
            this.streamProcessingMode(streamProcessingMode == null ? null : streamProcessingMode.toString());
            return this;
        }

        @Override
        public GuardrailStreamConfiguration build() {
            return new GuardrailStreamConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
