/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Asynchronous invocation output data settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AsyncInvokeS3OutputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AsyncInvokeS3OutputDataConfig.Builder, AsyncInvokeS3OutputDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Uri")
            .getter(getter(AsyncInvokeS3OutputDataConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(AsyncInvokeS3OutputDataConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketOwner").getter(getter(AsyncInvokeS3OutputDataConfig::bucketOwner))
            .setter(setter(Builder::bucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            KMS_KEY_ID_FIELD, BUCKET_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String kmsKeyId;

    private final String bucketOwner;

    private AsyncInvokeS3OutputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.kmsKeyId = builder.kmsKeyId;
        this.bucketOwner = builder.bucketOwner;
    }

    /**
     * <p>
     * An object URI starting with <code>s3://</code>.
     * </p>
     * 
     * @return An object URI starting with <code>s3://</code>.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * A KMS encryption key ID.
     * </p>
     * 
     * @return A KMS encryption key ID.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * If the bucket belongs to another AWS account, specify that account's ID.
     * </p>
     * 
     * @return If the bucket belongs to another AWS account, specify that account's ID.
     */
    public final String bucketOwner() {
        return bucketOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(bucketOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncInvokeS3OutputDataConfig)) {
            return false;
        }
        AsyncInvokeS3OutputDataConfig other = (AsyncInvokeS3OutputDataConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(bucketOwner(), other.bucketOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AsyncInvokeS3OutputDataConfig").add("S3Uri", s3Uri()).add("KmsKeyId", kmsKeyId())
                .add("BucketOwner", bucketOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "bucketOwner":
            return Optional.ofNullable(clazz.cast(bucketOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Uri", S3_URI_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("bucketOwner", BUCKET_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AsyncInvokeS3OutputDataConfig, T> g) {
        return obj -> g.apply((AsyncInvokeS3OutputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AsyncInvokeS3OutputDataConfig> {
        /**
         * <p>
         * An object URI starting with <code>s3://</code>.
         * </p>
         * 
         * @param s3Uri
         *        An object URI starting with <code>s3://</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * A KMS encryption key ID.
         * </p>
         * 
         * @param kmsKeyId
         *        A KMS encryption key ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * If the bucket belongs to another AWS account, specify that account's ID.
         * </p>
         * 
         * @param bucketOwner
         *        If the bucket belongs to another AWS account, specify that account's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketOwner(String bucketOwner);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String kmsKeyId;

        private String bucketOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncInvokeS3OutputDataConfig model) {
            s3Uri(model.s3Uri);
            kmsKeyId(model.kmsKeyId);
            bucketOwner(model.bucketOwner);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getBucketOwner() {
            return bucketOwner;
        }

        public final void setBucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
        }

        @Override
        public final Builder bucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
            return this;
        }

        @Override
        public AsyncInvokeS3OutputDataConfig build() {
            return new AsyncInvokeS3OutputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
