/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ImageBlock;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToolResultContentBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToolResultContentBlock> {
    private static final SdkField<Document> JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("json").getter(ToolResultContentBlock.getter(ToolResultContentBlock::json)).setter(ToolResultContentBlock.setter(Builder::json)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("json").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(ToolResultContentBlock.getter(ToolResultContentBlock::text)).setter(ToolResultContentBlock.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<ImageBlock> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("image").getter(ToolResultContentBlock.getter(ToolResultContentBlock::image)).setter(ToolResultContentBlock.setter(Builder::image)).constructor(ImageBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<DocumentBlock> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("document").getter(ToolResultContentBlock.getter(ToolResultContentBlock::document)).setter(ToolResultContentBlock.setter(Builder::document)).constructor(DocumentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_FIELD, TEXT_FIELD, IMAGE_FIELD, DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("json", JSON_FIELD);
            this.put("text", TEXT_FIELD);
            this.put("image", IMAGE_FIELD);
            this.put("document", DOCUMENT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Document json;
    private final String text;
    private final ImageBlock image;
    private final DocumentBlock document;
    private final Type type;

    private ToolResultContentBlock(BuilderImpl builder) {
        this.json = builder.json;
        this.text = builder.text;
        this.image = builder.image;
        this.document = builder.document;
        this.type = builder.type;
    }

    public final Document json() {
        return this.json;
    }

    public final String text() {
        return this.text;
    }

    public final ImageBlock image() {
        return this.image;
    }

    public final DocumentBlock document() {
        return this.document;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.json());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolResultContentBlock)) {
            return false;
        }
        ToolResultContentBlock other = (ToolResultContentBlock)obj;
        return Objects.equals(this.json(), other.json()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.document(), other.document());
    }

    public final String toString() {
        return ToString.builder((String)"ToolResultContentBlock").add("Json", (Object)this.json()).add("Text", (Object)this.text()).add("Image", (Object)this.image()).add("Document", (Object)this.document()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "json": {
                return Optional.ofNullable(clazz.cast(this.json()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
        }
        return Optional.empty();
    }

    public static ToolResultContentBlock fromJson(Document json) {
        return (ToolResultContentBlock)ToolResultContentBlock.builder().json(json).build();
    }

    public static ToolResultContentBlock fromText(String text) {
        return (ToolResultContentBlock)ToolResultContentBlock.builder().text(text).build();
    }

    public static ToolResultContentBlock fromImage(ImageBlock image) {
        return (ToolResultContentBlock)ToolResultContentBlock.builder().image(image).build();
    }

    public static ToolResultContentBlock fromImage(Consumer<ImageBlock.Builder> image) {
        ImageBlock.Builder builder = ImageBlock.builder();
        image.accept(builder);
        return ToolResultContentBlock.fromImage((ImageBlock)builder.build());
    }

    public static ToolResultContentBlock fromDocument(DocumentBlock document) {
        return (ToolResultContentBlock)ToolResultContentBlock.builder().document(document).build();
    }

    public static ToolResultContentBlock fromDocument(Consumer<DocumentBlock.Builder> document) {
        DocumentBlock.Builder builder = DocumentBlock.builder();
        document.accept(builder);
        return ToolResultContentBlock.fromDocument((DocumentBlock)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ToolResultContentBlock, T> g) {
        return obj -> g.apply((ToolResultContentBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        JSON,
        TEXT,
        IMAGE,
        DOCUMENT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Document json;
        private String text;
        private ImageBlock image;
        private DocumentBlock document;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ToolResultContentBlock model) {
            this.json(model.json);
            this.text(model.text);
            this.image(model.image);
            this.document(model.document);
        }

        public final Document getJson() {
            return this.json;
        }

        public final void setJson(Document json) {
            Document oldValue = this.json;
            this.json = json;
            this.handleUnionValueChange(Type.JSON, oldValue, this.json);
        }

        @Override
        public final Builder json(Document json) {
            Document oldValue = this.json;
            this.json = json;
            this.handleUnionValueChange(Type.JSON, oldValue, this.json);
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final ImageBlock.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(ImageBlock.BuilderImpl image) {
            ImageBlock oldValue = this.image;
            this.image = image != null ? image.build() : null;
            this.handleUnionValueChange(Type.IMAGE, oldValue, this.image);
        }

        @Override
        public final Builder image(ImageBlock image) {
            ImageBlock oldValue = this.image;
            this.image = image;
            this.handleUnionValueChange(Type.IMAGE, oldValue, this.image);
            return this;
        }

        public final DocumentBlock.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        public final void setDocument(DocumentBlock.BuilderImpl document) {
            DocumentBlock oldValue = this.document;
            this.document = document != null ? document.build() : null;
            this.handleUnionValueChange(Type.DOCUMENT, oldValue, this.document);
        }

        @Override
        public final Builder document(DocumentBlock document) {
            DocumentBlock oldValue = this.document;
            this.document = document;
            this.handleUnionValueChange(Type.DOCUMENT, oldValue, this.document);
            return this;
        }

        public ToolResultContentBlock build() {
            return new ToolResultContentBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToolResultContentBlock> {
        public Builder json(Document var1);

        public Builder text(String var1);

        public Builder image(ImageBlock var1);

        default public Builder image(Consumer<ImageBlock.Builder> image) {
            return this.image((ImageBlock)((ImageBlock.Builder)ImageBlock.builder().applyMutation(image)).build());
        }

        public Builder document(DocumentBlock var1);

        default public Builder document(Consumer<DocumentBlock.Builder> document) {
            return this.document((DocumentBlock)((DocumentBlock.Builder)DocumentBlock.builder().applyMutation(document)).build());
        }
    }
}

