/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A conversation stream metadata event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConverseStreamMetadataEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<ConverseStreamMetadataEvent.Builder, ConverseStreamMetadataEvent>, ConverseStreamOutput {
    private static final SdkField<TokenUsage> USAGE_FIELD = SdkField.<TokenUsage> builder(MarshallingType.SDK_POJO)
            .memberName("usage").getter(getter(ConverseStreamMetadataEvent::usage)).setter(setter(Builder::usage))
            .constructor(TokenUsage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build()).build();

    private static final SdkField<ConverseStreamMetrics> METRICS_FIELD = SdkField
            .<ConverseStreamMetrics> builder(MarshallingType.SDK_POJO).memberName("metrics")
            .getter(getter(ConverseStreamMetadataEvent::metrics)).setter(setter(Builder::metrics))
            .constructor(ConverseStreamMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()).build();

    private static final SdkField<ConverseStreamTrace> TRACE_FIELD = SdkField
            .<ConverseStreamTrace> builder(MarshallingType.SDK_POJO).memberName("trace")
            .getter(getter(ConverseStreamMetadataEvent::trace)).setter(setter(Builder::trace))
            .constructor(ConverseStreamTrace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_FIELD, METRICS_FIELD,
            TRACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final TokenUsage usage;

    private final ConverseStreamMetrics metrics;

    private final ConverseStreamTrace trace;

    protected ConverseStreamMetadataEvent(BuilderImpl builder) {
        this.usage = builder.usage;
        this.metrics = builder.metrics;
        this.trace = builder.trace;
    }

    /**
     * <p>
     * Usage information for the conversation stream event.
     * </p>
     * 
     * @return Usage information for the conversation stream event.
     */
    public final TokenUsage usage() {
        return usage;
    }

    /**
     * <p>
     * The metrics for the conversation stream metadata event.
     * </p>
     * 
     * @return The metrics for the conversation stream metadata event.
     */
    public final ConverseStreamMetrics metrics() {
        return metrics;
    }

    /**
     * <p>
     * The trace object in the response from <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>
     * that contains information about the guardrail behavior.
     * </p>
     * 
     * @return The trace object in the response from <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html"
     *         >ConverseStream</a> that contains information about the guardrail behavior.
     */
    public final ConverseStreamTrace trace() {
        return trace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usage());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(trace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConverseStreamMetadataEvent)) {
            return false;
        }
        ConverseStreamMetadataEvent other = (ConverseStreamMetadataEvent) obj;
        return Objects.equals(usage(), other.usage()) && Objects.equals(metrics(), other.metrics())
                && Objects.equals(trace(), other.trace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConverseStreamMetadataEvent").add("Usage", usage()).add("Metrics", metrics())
                .add("Trace", trace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usage":
            return Optional.ofNullable(clazz.cast(usage()));
        case "metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "trace":
            return Optional.ofNullable(clazz.cast(trace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final ConverseStreamMetadataEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConverseStreamMetadataEvent, T> g) {
        return obj -> g.apply((ConverseStreamMetadataEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link ConverseStreamMetadataEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(ConverseStreamResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConverseStreamMetadataEvent> {
        /**
         * <p>
         * Usage information for the conversation stream event.
         * </p>
         * 
         * @param usage
         *        Usage information for the conversation stream event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(TokenUsage usage);

        /**
         * <p>
         * Usage information for the conversation stream event.
         * </p>
         * This is a convenience method that creates an instance of the {@link TokenUsage.Builder} avoiding the need to
         * create one manually via {@link TokenUsage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TokenUsage.Builder#build()} is called immediately and its result
         * is passed to {@link #usage(TokenUsage)}.
         * 
         * @param usage
         *        a consumer that will call methods on {@link TokenUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usage(TokenUsage)
         */
        default Builder usage(Consumer<TokenUsage.Builder> usage) {
            return usage(TokenUsage.builder().applyMutation(usage).build());
        }

        /**
         * <p>
         * The metrics for the conversation stream metadata event.
         * </p>
         * 
         * @param metrics
         *        The metrics for the conversation stream metadata event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(ConverseStreamMetrics metrics);

        /**
         * <p>
         * The metrics for the conversation stream metadata event.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConverseStreamMetrics.Builder} avoiding
         * the need to create one manually via {@link ConverseStreamMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConverseStreamMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #metrics(ConverseStreamMetrics)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link ConverseStreamMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(ConverseStreamMetrics)
         */
        default Builder metrics(Consumer<ConverseStreamMetrics.Builder> metrics) {
            return metrics(ConverseStreamMetrics.builder().applyMutation(metrics).build());
        }

        /**
         * <p>
         * The trace object in the response from <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html"
         * >ConverseStream</a> that contains information about the guardrail behavior.
         * </p>
         * 
         * @param trace
         *        The trace object in the response from <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html"
         *        >ConverseStream</a> that contains information about the guardrail behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trace(ConverseStreamTrace trace);

        /**
         * <p>
         * The trace object in the response from <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html"
         * >ConverseStream</a> that contains information about the guardrail behavior.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConverseStreamTrace.Builder} avoiding the
         * need to create one manually via {@link ConverseStreamTrace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConverseStreamTrace.Builder#build()} is called immediately and
         * its result is passed to {@link #trace(ConverseStreamTrace)}.
         * 
         * @param trace
         *        a consumer that will call methods on {@link ConverseStreamTrace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trace(ConverseStreamTrace)
         */
        default Builder trace(Consumer<ConverseStreamTrace.Builder> trace) {
            return trace(ConverseStreamTrace.builder().applyMutation(trace).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private TokenUsage usage;

        private ConverseStreamMetrics metrics;

        private ConverseStreamTrace trace;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ConverseStreamMetadataEvent model) {
            usage(model.usage);
            metrics(model.metrics);
            trace(model.trace);
        }

        public final TokenUsage.Builder getUsage() {
            return usage != null ? usage.toBuilder() : null;
        }

        public final void setUsage(TokenUsage.BuilderImpl usage) {
            this.usage = usage != null ? usage.build() : null;
        }

        @Override
        public final Builder usage(TokenUsage usage) {
            this.usage = usage;
            return this;
        }

        public final ConverseStreamMetrics.Builder getMetrics() {
            return metrics != null ? metrics.toBuilder() : null;
        }

        public final void setMetrics(ConverseStreamMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(ConverseStreamMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final ConverseStreamTrace.Builder getTrace() {
            return trace != null ? trace.toBuilder() : null;
        }

        public final void setTrace(ConverseStreamTrace.BuilderImpl trace) {
            this.trace = trace != null ? trace.build() : null;
        }

        @Override
        public final Builder trace(ConverseStreamTrace trace) {
            this.trace = trace;
            return this;
        }

        @Override
        public ConverseStreamMetadataEvent build() {
            return new ConverseStreamMetadataEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
