/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.InferenceConfigurationStopSequencesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceConfiguration> {
    private static final SdkField<Integer> MAX_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxTokens").getter(InferenceConfiguration.getter(InferenceConfiguration::maxTokens)).setter(InferenceConfiguration.setter(Builder::maxTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxTokens").build()}).build();
    private static final SdkField<Float> TEMPERATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("temperature").getter(InferenceConfiguration.getter(InferenceConfiguration::temperature)).setter(InferenceConfiguration.setter(Builder::temperature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temperature").build()}).build();
    private static final SdkField<Float> TOPP_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("topP").getter(InferenceConfiguration.getter(InferenceConfiguration::topP)).setter(InferenceConfiguration.setter(Builder::topP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topP").build()}).build();
    private static final SdkField<List<String>> STOP_SEQUENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stopSequences").getter(InferenceConfiguration.getter(InferenceConfiguration::stopSequences)).setter(InferenceConfiguration.setter(Builder::stopSequences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopSequences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_TOKENS_FIELD, TEMPERATURE_FIELD, TOPP_FIELD, STOP_SEQUENCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maxTokens;
    private final Float temperature;
    private final Float topP;
    private final List<String> stopSequences;

    private InferenceConfiguration(BuilderImpl builder) {
        this.maxTokens = builder.maxTokens;
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.stopSequences = builder.stopSequences;
    }

    public final Integer maxTokens() {
        return this.maxTokens;
    }

    public final Float temperature() {
        return this.temperature;
    }

    public final Float topP() {
        return this.topP;
    }

    public final boolean hasStopSequences() {
        return this.stopSequences != null && !(this.stopSequences instanceof SdkAutoConstructList);
    }

    public final List<String> stopSequences() {
        return this.stopSequences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTokens());
        hashCode = 31 * hashCode + Objects.hashCode(this.temperature());
        hashCode = 31 * hashCode + Objects.hashCode(this.topP());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStopSequences() ? this.stopSequences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceConfiguration)) {
            return false;
        }
        InferenceConfiguration other = (InferenceConfiguration)obj;
        return Objects.equals(this.maxTokens(), other.maxTokens()) && Objects.equals(this.temperature(), other.temperature()) && Objects.equals(this.topP(), other.topP()) && this.hasStopSequences() == other.hasStopSequences() && Objects.equals(this.stopSequences(), other.stopSequences());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceConfiguration").add("MaxTokens", (Object)this.maxTokens()).add("Temperature", (Object)this.temperature()).add("TopP", (Object)this.topP()).add("StopSequences", this.hasStopSequences() ? this.stopSequences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxTokens": {
                return Optional.ofNullable(clazz.cast(this.maxTokens()));
            }
            case "temperature": {
                return Optional.ofNullable(clazz.cast(this.temperature()));
            }
            case "topP": {
                return Optional.ofNullable(clazz.cast(this.topP()));
            }
            case "stopSequences": {
                return Optional.ofNullable(clazz.cast(this.stopSequences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceConfiguration, T> g) {
        return obj -> g.apply((InferenceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxTokens;
        private Float temperature;
        private Float topP;
        private List<String> stopSequences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceConfiguration model) {
            this.maxTokens(model.maxTokens);
            this.temperature(model.temperature);
            this.topP(model.topP);
            this.stopSequences(model.stopSequences);
        }

        public final Integer getMaxTokens() {
            return this.maxTokens;
        }

        public final void setMaxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
        }

        @Override
        public final Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public final Float getTemperature() {
            return this.temperature;
        }

        public final void setTemperature(Float temperature) {
            this.temperature = temperature;
        }

        @Override
        public final Builder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public final Float getTopP() {
            return this.topP;
        }

        public final void setTopP(Float topP) {
            this.topP = topP;
        }

        @Override
        public final Builder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        public final Collection<String> getStopSequences() {
            if (this.stopSequences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stopSequences;
        }

        public final void setStopSequences(Collection<String> stopSequences) {
            this.stopSequences = InferenceConfigurationStopSequencesListCopier.copy(stopSequences);
        }

        @Override
        public final Builder stopSequences(Collection<String> stopSequences) {
            this.stopSequences = InferenceConfigurationStopSequencesListCopier.copy(stopSequences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopSequences(String ... stopSequences) {
            this.stopSequences(Arrays.asList(stopSequences));
            return this;
        }

        public InferenceConfiguration build() {
            return new InferenceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceConfiguration> {
        public Builder maxTokens(Integer var1);

        public Builder temperature(Float var1);

        public Builder topP(Float var1);

        public Builder stopSequences(Collection<String> var1);

        public Builder stopSequences(String ... var1);
    }
}

