/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a tool that you can use with the Converse API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Tool implements SdkPojo, Serializable, ToCopyableBuilder<Tool.Builder, Tool> {
    private static final SdkField<ToolSpecification> TOOL_SPEC_FIELD = SdkField
            .<ToolSpecification> builder(MarshallingType.SDK_POJO).memberName("toolSpec").getter(getter(Tool::toolSpec))
            .setter(setter(Builder::toolSpec)).constructor(ToolSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolSpec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOL_SPEC_FIELD));

    private static final long serialVersionUID = 1L;

    private final ToolSpecification toolSpec;

    private final Type type;

    private Tool(BuilderImpl builder) {
        this.toolSpec = builder.toolSpec;
        this.type = builder.type;
    }

    /**
     * <p>
     * The specfication for the tool.
     * </p>
     * 
     * @return The specfication for the tool.
     */
    public final ToolSpecification toolSpec() {
        return toolSpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(toolSpec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tool)) {
            return false;
        }
        Tool other = (Tool) obj;
        return Objects.equals(toolSpec(), other.toolSpec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Tool").add("ToolSpec", toolSpec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "toolSpec":
            return Optional.ofNullable(clazz.cast(toolSpec()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #toolSpec()} initialized to the given value.
     *
     * <p>
     * The specfication for the tool.
     * </p>
     * 
     * @param toolSpec
     *        The specfication for the tool.
     */
    public static Tool fromToolSpec(ToolSpecification toolSpec) {
        return builder().toolSpec(toolSpec).build();
    }

    /**
     * Create an instance of this class with {@link #toolSpec()} initialized to the given value.
     *
     * <p>
     * The specfication for the tool.
     * </p>
     * 
     * @param toolSpec
     *        The specfication for the tool.
     */
    public static Tool fromToolSpec(Consumer<ToolSpecification.Builder> toolSpec) {
        ToolSpecification.Builder builder = ToolSpecification.builder();
        toolSpec.accept(builder);
        return fromToolSpec(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tool, T> g) {
        return obj -> g.apply((Tool) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Tool> {
        /**
         * <p>
         * The specfication for the tool.
         * </p>
         * 
         * @param toolSpec
         *        The specfication for the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolSpec(ToolSpecification toolSpec);

        /**
         * <p>
         * The specfication for the tool.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolSpecification.Builder} avoiding the
         * need to create one manually via {@link ToolSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolSpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #toolSpec(ToolSpecification)}.
         * 
         * @param toolSpec
         *        a consumer that will call methods on {@link ToolSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolSpec(ToolSpecification)
         */
        default Builder toolSpec(Consumer<ToolSpecification.Builder> toolSpec) {
            return toolSpec(ToolSpecification.builder().applyMutation(toolSpec).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ToolSpecification toolSpec;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Tool model) {
            toolSpec(model.toolSpec);
        }

        public final ToolSpecification.Builder getToolSpec() {
            return toolSpec != null ? toolSpec.toBuilder() : null;
        }

        public final void setToolSpec(ToolSpecification.BuilderImpl toolSpec) {
            Object oldValue = this.toolSpec;
            this.toolSpec = toolSpec != null ? toolSpec.build() : null;
            handleUnionValueChange(Type.TOOL_SPEC, oldValue, this.toolSpec);
        }

        @Override
        public final Builder toolSpec(ToolSpecification toolSpec) {
            Object oldValue = this.toolSpec;
            this.toolSpec = toolSpec;
            handleUnionValueChange(Type.TOOL_SPEC, oldValue, this.toolSpec);
            return this;
        }

        @Override
        public Tool build() {
            return new Tool(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Tool#type()
     */
    public enum Type {
        TOOL_SPEC,

        UNKNOWN_TO_SDK_VERSION
    }
}
