/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.AutomationJobStatus;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.BedrockDataAutomationRuntimeResponse;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.OutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataAutomationStatusResponse
extends BedrockDataAutomationRuntimeResponse
implements ToCopyableBuilder<Builder, GetDataAutomationStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetDataAutomationStatusResponse.getter(GetDataAutomationStatusResponse::statusAsString)).setter(GetDataAutomationStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorType").getter(GetDataAutomationStatusResponse.getter(GetDataAutomationStatusResponse::errorType)).setter(GetDataAutomationStatusResponse.setter(Builder::errorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(GetDataAutomationStatusResponse.getter(GetDataAutomationStatusResponse::errorMessage)).setter(GetDataAutomationStatusResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<OutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfiguration").getter(GetDataAutomationStatusResponse.getter(GetDataAutomationStatusResponse::outputConfiguration)).setter(GetDataAutomationStatusResponse.setter(Builder::outputConfiguration)).constructor(OutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ERROR_TYPE_FIELD, ERROR_MESSAGE_FIELD, OUTPUT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDataAutomationStatusResponse.memberNameToFieldInitializer();
    private final String status;
    private final String errorType;
    private final String errorMessage;
    private final OutputConfiguration outputConfiguration;

    private GetDataAutomationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.errorType = builder.errorType;
        this.errorMessage = builder.errorMessage;
        this.outputConfiguration = builder.outputConfiguration;
    }

    public final AutomationJobStatus status() {
        return AutomationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorType() {
        return this.errorType;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final OutputConfiguration outputConfiguration() {
        return this.outputConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorType());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataAutomationStatusResponse)) {
            return false;
        }
        GetDataAutomationStatusResponse other = (GetDataAutomationStatusResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorType(), other.errorType()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.outputConfiguration(), other.outputConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataAutomationStatusResponse").add("Status", (Object)this.statusAsString()).add("ErrorType", (Object)this.errorType()).add("ErrorMessage", (Object)this.errorMessage()).add("OutputConfiguration", (Object)this.outputConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "errorType": {
                return Optional.ofNullable(clazz.cast(this.errorType()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "outputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("errorType", ERROR_TYPE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataAutomationStatusResponse, T> g) {
        return obj -> g.apply((GetDataAutomationStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockDataAutomationRuntimeResponse.BuilderImpl
    implements Builder {
        private String status;
        private String errorType;
        private String errorMessage;
        private OutputConfiguration outputConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataAutomationStatusResponse model) {
            super(model);
            this.status(model.status);
            this.errorType(model.errorType);
            this.errorMessage(model.errorMessage);
            this.outputConfiguration(model.outputConfiguration);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutomationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorType() {
            return this.errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final OutputConfiguration.Builder getOutputConfiguration() {
            return this.outputConfiguration != null ? this.outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(OutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(OutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        @Override
        public GetDataAutomationStatusResponse build() {
            return new GetDataAutomationStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockDataAutomationRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataAutomationStatusResponse> {
        public Builder status(String var1);

        public Builder status(AutomationJobStatus var1);

        public Builder errorType(String var1);

        public Builder errorMessage(String var1);

        public Builder outputConfiguration(OutputConfiguration var1);

        default public Builder outputConfiguration(Consumer<OutputConfiguration.Builder> outputConfiguration) {
            return this.outputConfiguration((OutputConfiguration)((OutputConfiguration.Builder)OutputConfiguration.builder().applyMutation(outputConfiguration)).build());
        }
    }
}

