/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.BedrockDataAutomationRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.CustomOutputConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectStage;
import software.amazon.awssdk.services.bedrockdataautomation.model.EncryptionConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.OverrideConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.StandardOutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataAutomationProjectRequest
extends BedrockDataAutomationRequest
implements ToCopyableBuilder<Builder, CreateDataAutomationProjectRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(CreateDataAutomationProjectRequest.getter(CreateDataAutomationProjectRequest::projectName)).setter(CreateDataAutomationProjectRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectDescription").getter(CreateDataAutomationProjectRequest.getter(CreateDataAutomationProjectRequest::projectDescription)).setter(CreateDataAutomationProjectRequest.setter(Builder::projectDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectDescription").build()}).build();
    private static final SdkField<String> PROJECT_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectStage").getter(CreateDataAutomationProjectRequest.getter(CreateDataAutomationProjectRequest::projectStageAsString)).setter(CreateDataAutomationProjectRequest.setter(Builder::projectStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectStage").build()}).build();
    private static final SdkField<StandardOutputConfiguration> STANDARD_OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("standardOutputConfiguration").getter(CreateDataAutomationProjectRequest.getter(CreateDataAutomationProjectRequest::standardOutputConfiguration)).setter(CreateDataAutomationProjectRequest.setter(Builder::standardOutputConfiguration)).constructor(StandardOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardOutputConfiguration").build()}).build();
    private static final SdkField<CustomOutputConfiguration> CUSTOM_OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customOutputConfiguration").getter(CreateDataAutomationProjectRequest.getter(CreateDataAutomationProjectRequest::customOutputConfiguration)).setter(CreateDataAutomationProjectRequest.setter(Builder::customOutputConfiguration)).constructor(CustomOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customOutputConfiguration").build()}).build();
    private static final SdkField<OverrideConfiguration> OVERRIDE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("overrideConfiguration").getter(CreateDataAutomationProjectRequest.getter(CreateDataAutomationProjectRequest::overrideConfigurationValue)).setter(CreateDataAutomationProjectRequest.setter(Builder::overrideConfigurationValue)).constructor(OverrideConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDataAutomationProjectRequest.getter(CreateDataAutomationProjectRequest::clientToken)).setter(CreateDataAutomationProjectRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(CreateDataAutomationProjectRequest.getter(CreateDataAutomationProjectRequest::encryptionConfiguration)).setter(CreateDataAutomationProjectRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, PROJECT_DESCRIPTION_FIELD, PROJECT_STAGE_FIELD, STANDARD_OUTPUT_CONFIGURATION_FIELD, CUSTOM_OUTPUT_CONFIGURATION_FIELD, OVERRIDE_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataAutomationProjectRequest.memberNameToFieldInitializer();
    private final String projectName;
    private final String projectDescription;
    private final String projectStage;
    private final StandardOutputConfiguration standardOutputConfiguration;
    private final CustomOutputConfiguration customOutputConfiguration;
    private final OverrideConfiguration overrideConfigurationValue;
    private final String clientToken;
    private final EncryptionConfiguration encryptionConfiguration;

    private CreateDataAutomationProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.projectDescription = builder.projectDescription;
        this.projectStage = builder.projectStage;
        this.standardOutputConfiguration = builder.standardOutputConfiguration;
        this.customOutputConfiguration = builder.customOutputConfiguration;
        this.overrideConfigurationValue = builder.overrideConfigurationValue;
        this.clientToken = builder.clientToken;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String projectDescription() {
        return this.projectDescription;
    }

    public final DataAutomationProjectStage projectStage() {
        return DataAutomationProjectStage.fromValue(this.projectStage);
    }

    public final String projectStageAsString() {
        return this.projectStage;
    }

    public final StandardOutputConfiguration standardOutputConfiguration() {
        return this.standardOutputConfiguration;
    }

    public final CustomOutputConfiguration customOutputConfiguration() {
        return this.customOutputConfiguration;
    }

    public final OverrideConfiguration overrideConfigurationValue() {
        return this.overrideConfigurationValue;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideConfigurationValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataAutomationProjectRequest)) {
            return false;
        }
        CreateDataAutomationProjectRequest other = (CreateDataAutomationProjectRequest)((Object)obj);
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.projectDescription(), other.projectDescription()) && Objects.equals(this.projectStageAsString(), other.projectStageAsString()) && Objects.equals(this.standardOutputConfiguration(), other.standardOutputConfiguration()) && Objects.equals(this.customOutputConfiguration(), other.customOutputConfiguration()) && Objects.equals(this.overrideConfigurationValue(), other.overrideConfigurationValue()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataAutomationProjectRequest").add("ProjectName", (Object)(this.projectName() == null ? null : "*** Sensitive Data Redacted ***")).add("ProjectDescription", (Object)(this.projectDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("ProjectStage", (Object)this.projectStageAsString()).add("StandardOutputConfiguration", (Object)this.standardOutputConfiguration()).add("CustomOutputConfiguration", (Object)this.customOutputConfiguration()).add("OverrideConfiguration", (Object)this.overrideConfigurationValue()).add("ClientToken", (Object)this.clientToken()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "projectDescription": {
                return Optional.ofNullable(clazz.cast(this.projectDescription()));
            }
            case "projectStage": {
                return Optional.ofNullable(clazz.cast(this.projectStageAsString()));
            }
            case "standardOutputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.standardOutputConfiguration()));
            }
            case "customOutputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customOutputConfiguration()));
            }
            case "overrideConfiguration": {
                return Optional.ofNullable(clazz.cast(this.overrideConfigurationValue()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("projectDescription", PROJECT_DESCRIPTION_FIELD);
        map.put("projectStage", PROJECT_STAGE_FIELD);
        map.put("standardOutputConfiguration", STANDARD_OUTPUT_CONFIGURATION_FIELD);
        map.put("customOutputConfiguration", CUSTOM_OUTPUT_CONFIGURATION_FIELD);
        map.put("overrideConfiguration", OVERRIDE_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataAutomationProjectRequest, T> g) {
        return obj -> g.apply((CreateDataAutomationProjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockDataAutomationRequest.BuilderImpl
    implements Builder {
        private String projectName;
        private String projectDescription;
        private String projectStage;
        private StandardOutputConfiguration standardOutputConfiguration;
        private CustomOutputConfiguration customOutputConfiguration;
        private OverrideConfiguration overrideConfigurationValue;
        private String clientToken;
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataAutomationProjectRequest model) {
            super(model);
            this.projectName(model.projectName);
            this.projectDescription(model.projectDescription);
            this.projectStage(model.projectStage);
            this.standardOutputConfiguration(model.standardOutputConfiguration);
            this.customOutputConfiguration(model.customOutputConfiguration);
            this.overrideConfigurationValue(model.overrideConfigurationValue);
            this.clientToken(model.clientToken);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getProjectDescription() {
            return this.projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final String getProjectStage() {
            return this.projectStage;
        }

        public final void setProjectStage(String projectStage) {
            this.projectStage = projectStage;
        }

        @Override
        public final Builder projectStage(String projectStage) {
            this.projectStage = projectStage;
            return this;
        }

        @Override
        public final Builder projectStage(DataAutomationProjectStage projectStage) {
            this.projectStage(projectStage == null ? null : projectStage.toString());
            return this;
        }

        public final StandardOutputConfiguration.Builder getStandardOutputConfiguration() {
            return this.standardOutputConfiguration != null ? this.standardOutputConfiguration.toBuilder() : null;
        }

        public final void setStandardOutputConfiguration(StandardOutputConfiguration.BuilderImpl standardOutputConfiguration) {
            this.standardOutputConfiguration = standardOutputConfiguration != null ? standardOutputConfiguration.build() : null;
        }

        @Override
        public final Builder standardOutputConfiguration(StandardOutputConfiguration standardOutputConfiguration) {
            this.standardOutputConfiguration = standardOutputConfiguration;
            return this;
        }

        public final CustomOutputConfiguration.Builder getCustomOutputConfiguration() {
            return this.customOutputConfiguration != null ? this.customOutputConfiguration.toBuilder() : null;
        }

        public final void setCustomOutputConfiguration(CustomOutputConfiguration.BuilderImpl customOutputConfiguration) {
            this.customOutputConfiguration = customOutputConfiguration != null ? customOutputConfiguration.build() : null;
        }

        @Override
        public final Builder customOutputConfiguration(CustomOutputConfiguration customOutputConfiguration) {
            this.customOutputConfiguration = customOutputConfiguration;
            return this;
        }

        public final OverrideConfiguration.Builder getOverrideConfigurationValue() {
            return this.overrideConfigurationValue != null ? this.overrideConfigurationValue.toBuilder() : null;
        }

        public final void setOverrideConfigurationValue(OverrideConfiguration.BuilderImpl overrideConfigurationValue) {
            this.overrideConfigurationValue = overrideConfigurationValue != null ? overrideConfigurationValue.build() : null;
        }

        @Override
        public final Builder overrideConfigurationValue(OverrideConfiguration overrideConfigurationValue) {
            this.overrideConfigurationValue = overrideConfigurationValue;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataAutomationProjectRequest build() {
            return new CreateDataAutomationProjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockDataAutomationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataAutomationProjectRequest> {
        public Builder projectName(String var1);

        public Builder projectDescription(String var1);

        public Builder projectStage(String var1);

        public Builder projectStage(DataAutomationProjectStage var1);

        public Builder standardOutputConfiguration(StandardOutputConfiguration var1);

        default public Builder standardOutputConfiguration(Consumer<StandardOutputConfiguration.Builder> standardOutputConfiguration) {
            return this.standardOutputConfiguration((StandardOutputConfiguration)((StandardOutputConfiguration.Builder)StandardOutputConfiguration.builder().applyMutation(standardOutputConfiguration)).build());
        }

        public Builder customOutputConfiguration(CustomOutputConfiguration var1);

        default public Builder customOutputConfiguration(Consumer<CustomOutputConfiguration.Builder> customOutputConfiguration) {
            return this.customOutputConfiguration((CustomOutputConfiguration)((CustomOutputConfiguration.Builder)CustomOutputConfiguration.builder().applyMutation(customOutputConfiguration)).build());
        }

        public Builder overrideConfigurationValue(OverrideConfiguration var1);

        default public Builder overrideConfigurationValue(Consumer<OverrideConfiguration.Builder> overrideConfigurationValue) {
            return this.overrideConfigurationValue((OverrideConfiguration)((OverrideConfiguration.Builder)OverrideConfiguration.builder().applyMutation(overrideConfigurationValue)).build());
        }

        public Builder clientToken(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

