/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model.flowresponsestream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowMultiTurnInputRequestEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowResponseStream;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeFlowResponseHandler;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockagentruntime.model.FlowMultiTurnInputRequestEvent}
 * that represents the {@code FlowResponseStream$flowMultiTurnInputRequestEvent} event. Do not use this class directly.
 * Instead, use the static builder methods on
 * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowResponseStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultFlowMultiTurnInputRequestEvent extends FlowMultiTurnInputRequestEvent {
    private static final long serialVersionUID = 1L;

    DefaultFlowMultiTurnInputRequestEvent(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(InvokeFlowResponseHandler.Visitor visitor) {
        visitor.visitFlowMultiTurnInputRequestEvent(this);
    }

    @Override
    public FlowResponseStream.EventType sdkEventType() {
        return FlowResponseStream.EventType.FLOW_MULTI_TURN_INPUT_REQUEST_EVENT;
    }

    public interface Builder extends FlowMultiTurnInputRequestEvent.Builder {
        @Override
        DefaultFlowMultiTurnInputRequestEvent build();
    }

    private static final class BuilderImpl extends FlowMultiTurnInputRequestEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultFlowMultiTurnInputRequestEvent event) {
            super(event);
        }

        @Override
        public DefaultFlowMultiTurnInputRequestEvent build() {
            return new DefaultFlowMultiTurnInputRequestEvent(this);
        }
    }
}
