/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopFlowExecutionRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<StopFlowExecutionRequest.Builder, StopFlowExecutionRequest> {
    private static final SdkField<String> EXECUTION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionIdentifier").getter(getter(StopFlowExecutionRequest::executionIdentifier))
            .setter(setter(Builder::executionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("executionIdentifier").build()).build();

    private static final SdkField<String> FLOW_ALIAS_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowAliasIdentifier").getter(getter(StopFlowExecutionRequest::flowAliasIdentifier))
            .setter(setter(Builder::flowAliasIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowAliasIdentifier").build()).build();

    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowIdentifier").getter(getter(StopFlowExecutionRequest::flowIdentifier))
            .setter(setter(Builder::flowIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_IDENTIFIER_FIELD,
            FLOW_ALIAS_IDENTIFIER_FIELD, FLOW_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String executionIdentifier;

    private final String flowAliasIdentifier;

    private final String flowIdentifier;

    private StopFlowExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.executionIdentifier = builder.executionIdentifier;
        this.flowAliasIdentifier = builder.flowAliasIdentifier;
        this.flowIdentifier = builder.flowIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the flow execution to stop.
     * </p>
     * 
     * @return The unique identifier of the flow execution to stop.
     */
    public final String executionIdentifier() {
        return executionIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the flow alias used for the execution.
     * </p>
     * 
     * @return The unique identifier of the flow alias used for the execution.
     */
    public final String flowAliasIdentifier() {
        return flowAliasIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the flow.
     * </p>
     * 
     * @return The unique identifier of the flow.
     */
    public final String flowIdentifier() {
        return flowIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(flowAliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(flowIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopFlowExecutionRequest)) {
            return false;
        }
        StopFlowExecutionRequest other = (StopFlowExecutionRequest) obj;
        return Objects.equals(executionIdentifier(), other.executionIdentifier())
                && Objects.equals(flowAliasIdentifier(), other.flowAliasIdentifier())
                && Objects.equals(flowIdentifier(), other.flowIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopFlowExecutionRequest").add("ExecutionIdentifier", executionIdentifier())
                .add("FlowAliasIdentifier", flowAliasIdentifier()).add("FlowIdentifier", flowIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionIdentifier":
            return Optional.ofNullable(clazz.cast(executionIdentifier()));
        case "flowAliasIdentifier":
            return Optional.ofNullable(clazz.cast(flowAliasIdentifier()));
        case "flowIdentifier":
            return Optional.ofNullable(clazz.cast(flowIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionIdentifier", EXECUTION_IDENTIFIER_FIELD);
        map.put("flowAliasIdentifier", FLOW_ALIAS_IDENTIFIER_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopFlowExecutionRequest, T> g) {
        return obj -> g.apply((StopFlowExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StopFlowExecutionRequest> {
        /**
         * <p>
         * The unique identifier of the flow execution to stop.
         * </p>
         * 
         * @param executionIdentifier
         *        The unique identifier of the flow execution to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionIdentifier(String executionIdentifier);

        /**
         * <p>
         * The unique identifier of the flow alias used for the execution.
         * </p>
         * 
         * @param flowAliasIdentifier
         *        The unique identifier of the flow alias used for the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowAliasIdentifier(String flowAliasIdentifier);

        /**
         * <p>
         * The unique identifier of the flow.
         * </p>
         * 
         * @param flowIdentifier
         *        The unique identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowIdentifier(String flowIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private String executionIdentifier;

        private String flowAliasIdentifier;

        private String flowIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StopFlowExecutionRequest model) {
            super(model);
            executionIdentifier(model.executionIdentifier);
            flowAliasIdentifier(model.flowAliasIdentifier);
            flowIdentifier(model.flowIdentifier);
        }

        public final String getExecutionIdentifier() {
            return executionIdentifier;
        }

        public final void setExecutionIdentifier(String executionIdentifier) {
            this.executionIdentifier = executionIdentifier;
        }

        @Override
        public final Builder executionIdentifier(String executionIdentifier) {
            this.executionIdentifier = executionIdentifier;
            return this;
        }

        public final String getFlowAliasIdentifier() {
            return flowAliasIdentifier;
        }

        public final void setFlowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
        }

        @Override
        public final Builder flowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
            return this;
        }

        public final String getFlowIdentifier() {
            return flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopFlowExecutionRequest build() {
            return new StopFlowExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
