/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a chunk of text from a data source in the knowledge base. If the result is from a
 * structured data source, the cell in the database and the type of the value is also identified.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax"
 * >Retrieve response</a> – in the <code>content</code> field
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax"
 * >RetrieveAndGenerate response</a> – in the <code>content</code> field
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax"
 * >InvokeAgent response</a> – in the <code>content</code> field
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrievalResultContent implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrievalResultContent.Builder, RetrievalResultContent> {
    private static final SdkField<AudioSegment> AUDIO_FIELD = SdkField.<AudioSegment> builder(MarshallingType.SDK_POJO)
            .memberName("audio").getter(getter(RetrievalResultContent::audio)).setter(setter(Builder::audio))
            .constructor(AudioSegment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audio").build()).build();

    private static final SdkField<String> BYTE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("byteContent").getter(getter(RetrievalResultContent::byteContent)).setter(setter(Builder::byteContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byteContent").build()).build();

    private static final SdkField<List<RetrievalResultContentColumn>> ROW_FIELD = SdkField
            .<List<RetrievalResultContentColumn>> builder(MarshallingType.LIST)
            .memberName("row")
            .getter(getter(RetrievalResultContent::row))
            .setter(setter(Builder::row))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("row").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RetrievalResultContentColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(RetrievalResultContentColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(RetrievalResultContent::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RetrievalResultContent::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<VideoSegment> VIDEO_FIELD = SdkField.<VideoSegment> builder(MarshallingType.SDK_POJO)
            .memberName("video").getter(getter(RetrievalResultContent::video)).setter(setter(Builder::video))
            .constructor(VideoSegment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FIELD,
            BYTE_CONTENT_FIELD, ROW_FIELD, TEXT_FIELD, TYPE_FIELD, VIDEO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AudioSegment audio;

    private final String byteContent;

    private final List<RetrievalResultContentColumn> row;

    private final String text;

    private final String type;

    private final VideoSegment video;

    private RetrievalResultContent(BuilderImpl builder) {
        this.audio = builder.audio;
        this.byteContent = builder.byteContent;
        this.row = builder.row;
        this.text = builder.text;
        this.type = builder.type;
        this.video = builder.video;
    }

    /**
     * <p>
     * Audio segment information when the retrieval result contains audio content.
     * </p>
     * 
     * @return Audio segment information when the retrieval result contains audio content.
     */
    public final AudioSegment audio() {
        return audio;
    }

    /**
     * <p>
     * A data URI with base64-encoded content from the data source. The URI is in the following format: returned in the
     * following format: <code>data:image/jpeg;base64,${base64-encoded string}</code>.
     * </p>
     * 
     * @return A data URI with base64-encoded content from the data source. The URI is in the following format: returned
     *         in the following format: <code>data:image/jpeg;base64,${base64-encoded string}</code>.
     */
    public final String byteContent() {
        return byteContent;
    }

    /**
     * For responses, this returns true if the service returned a value for the Row property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRow() {
        return row != null && !(row instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies information about the rows with the cells to return in retrieval.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRow} method.
     * </p>
     * 
     * @return Specifies information about the rows with the cells to return in retrieval.
     */
    public final List<RetrievalResultContentColumn> row() {
        return row;
    }

    /**
     * <p>
     * The cited text from the data source.
     * </p>
     * 
     * @return The cited text from the data source.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The type of content in the retrieval result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrievalResultContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of content in the retrieval result.
     * @see RetrievalResultContentType
     */
    public final RetrievalResultContentType type() {
        return RetrievalResultContentType.fromValue(type);
    }

    /**
     * <p>
     * The type of content in the retrieval result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrievalResultContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of content in the retrieval result.
     * @see RetrievalResultContentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Video segment information when the retrieval result contains video content.
     * </p>
     * 
     * @return Video segment information when the retrieval result contains video content.
     */
    public final VideoSegment video() {
        return video;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audio());
        hashCode = 31 * hashCode + Objects.hashCode(byteContent());
        hashCode = 31 * hashCode + Objects.hashCode(hasRow() ? row() : null);
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalResultContent)) {
            return false;
        }
        RetrievalResultContent other = (RetrievalResultContent) obj;
        return Objects.equals(audio(), other.audio()) && Objects.equals(byteContent(), other.byteContent())
                && hasRow() == other.hasRow() && Objects.equals(row(), other.row()) && Objects.equals(text(), other.text())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(video(), other.video());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrievalResultContent").add("Audio", audio()).add("ByteContent", byteContent())
                .add("Row", row() == null ? null : "*** Sensitive Data Redacted ***").add("Text", text())
                .add("Type", typeAsString()).add("Video", video()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "audio":
            return Optional.ofNullable(clazz.cast(audio()));
        case "byteContent":
            return Optional.ofNullable(clazz.cast(byteContent()));
        case "row":
            return Optional.ofNullable(clazz.cast(row()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "video":
            return Optional.ofNullable(clazz.cast(video()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("audio", AUDIO_FIELD);
        map.put("byteContent", BYTE_CONTENT_FIELD);
        map.put("row", ROW_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("video", VIDEO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrievalResultContent, T> g) {
        return obj -> g.apply((RetrievalResultContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrievalResultContent> {
        /**
         * <p>
         * Audio segment information when the retrieval result contains audio content.
         * </p>
         * 
         * @param audio
         *        Audio segment information when the retrieval result contains audio content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audio(AudioSegment audio);

        /**
         * <p>
         * Audio segment information when the retrieval result contains audio content.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudioSegment.Builder} avoiding the need
         * to create one manually via {@link AudioSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioSegment.Builder#build()} is called immediately and its
         * result is passed to {@link #audio(AudioSegment)}.
         * 
         * @param audio
         *        a consumer that will call methods on {@link AudioSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audio(AudioSegment)
         */
        default Builder audio(Consumer<AudioSegment.Builder> audio) {
            return audio(AudioSegment.builder().applyMutation(audio).build());
        }

        /**
         * <p>
         * A data URI with base64-encoded content from the data source. The URI is in the following format: returned in
         * the following format: <code>data:image/jpeg;base64,${base64-encoded string}</code>.
         * </p>
         * 
         * @param byteContent
         *        A data URI with base64-encoded content from the data source. The URI is in the following format:
         *        returned in the following format: <code>data:image/jpeg;base64,${base64-encoded string}</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteContent(String byteContent);

        /**
         * <p>
         * Specifies information about the rows with the cells to return in retrieval.
         * </p>
         * 
         * @param row
         *        Specifies information about the rows with the cells to return in retrieval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder row(Collection<RetrievalResultContentColumn> row);

        /**
         * <p>
         * Specifies information about the rows with the cells to return in retrieval.
         * </p>
         * 
         * @param row
         *        Specifies information about the rows with the cells to return in retrieval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder row(RetrievalResultContentColumn... row);

        /**
         * <p>
         * Specifies information about the rows with the cells to return in retrieval.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalResultContentColumn.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalResultContentColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalResultContentColumn.Builder#build()}
         * is called immediately and its result is passed to {@link #row(List<RetrievalResultContentColumn>)}.
         * 
         * @param row
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalResultContentColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #row(java.util.Collection<RetrievalResultContentColumn>)
         */
        Builder row(Consumer<RetrievalResultContentColumn.Builder>... row);

        /**
         * <p>
         * The cited text from the data source.
         * </p>
         * 
         * @param text
         *        The cited text from the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The type of content in the retrieval result.
         * </p>
         * 
         * @param type
         *        The type of content in the retrieval result.
         * @see RetrievalResultContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalResultContentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of content in the retrieval result.
         * </p>
         * 
         * @param type
         *        The type of content in the retrieval result.
         * @see RetrievalResultContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalResultContentType
         */
        Builder type(RetrievalResultContentType type);

        /**
         * <p>
         * Video segment information when the retrieval result contains video content.
         * </p>
         * 
         * @param video
         *        Video segment information when the retrieval result contains video content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(VideoSegment video);

        /**
         * <p>
         * Video segment information when the retrieval result contains video content.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoSegment.Builder} avoiding the need
         * to create one manually via {@link VideoSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoSegment.Builder#build()} is called immediately and its
         * result is passed to {@link #video(VideoSegment)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link VideoSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(VideoSegment)
         */
        default Builder video(Consumer<VideoSegment.Builder> video) {
            return video(VideoSegment.builder().applyMutation(video).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AudioSegment audio;

        private String byteContent;

        private List<RetrievalResultContentColumn> row = DefaultSdkAutoConstructList.getInstance();

        private String text;

        private String type;

        private VideoSegment video;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalResultContent model) {
            audio(model.audio);
            byteContent(model.byteContent);
            row(model.row);
            text(model.text);
            type(model.type);
            video(model.video);
        }

        public final AudioSegment.Builder getAudio() {
            return audio != null ? audio.toBuilder() : null;
        }

        public final void setAudio(AudioSegment.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioSegment audio) {
            this.audio = audio;
            return this;
        }

        public final String getByteContent() {
            return byteContent;
        }

        public final void setByteContent(String byteContent) {
            this.byteContent = byteContent;
        }

        @Override
        public final Builder byteContent(String byteContent) {
            this.byteContent = byteContent;
            return this;
        }

        public final List<RetrievalResultContentColumn.Builder> getRow() {
            List<RetrievalResultContentColumn.Builder> result = RetrievalResultContentRowCopier.copyToBuilder(this.row);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRow(Collection<RetrievalResultContentColumn.BuilderImpl> row) {
            this.row = RetrievalResultContentRowCopier.copyFromBuilder(row);
        }

        @Override
        public final Builder row(Collection<RetrievalResultContentColumn> row) {
            this.row = RetrievalResultContentRowCopier.copy(row);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder row(RetrievalResultContentColumn... row) {
            row(Arrays.asList(row));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder row(Consumer<RetrievalResultContentColumn.Builder>... row) {
            row(Stream.of(row).map(c -> RetrievalResultContentColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrievalResultContentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final VideoSegment.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        public final void setVideo(VideoSegment.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(VideoSegment video) {
            this.video = video;
            return this;
        }

        @Override
        public RetrievalResultContent build() {
            return new RetrievalResultContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
