/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the agent's response to reprompt the input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepromptResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<RepromptResponse.Builder, RepromptResponse> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(RepromptResponse::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(RepromptResponse::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String text;

    private RepromptResponse(BuilderImpl builder) {
        this.source = builder.source;
        this.text = builder.text;
    }

    /**
     * <p>
     * Specifies what output is prompting the agent to reprompt the input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return Specifies what output is prompting the agent to reprompt the input.
     * @see Source
     */
    public final Source source() {
        return Source.fromValue(source);
    }

    /**
     * <p>
     * Specifies what output is prompting the agent to reprompt the input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return Specifies what output is prompting the agent to reprompt the input.
     * @see Source
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * <p>
     * The text reprompting the input.
     * </p>
     * 
     * @return The text reprompting the input.
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepromptResponse)) {
            return false;
        }
        RepromptResponse other = (RepromptResponse) obj;
        return Objects.equals(sourceAsString(), other.sourceAsString()) && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepromptResponse")
                .add("Source", sourceAsString() == null ? null : "*** Sensitive Data Redacted ***").add("Text", text()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("text", TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepromptResponse, T> g) {
        return obj -> g.apply((RepromptResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepromptResponse> {
        /**
         * <p>
         * Specifies what output is prompting the agent to reprompt the input.
         * </p>
         * 
         * @param source
         *        Specifies what output is prompting the agent to reprompt the input.
         * @see Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Source
         */
        Builder source(String source);

        /**
         * <p>
         * Specifies what output is prompting the agent to reprompt the input.
         * </p>
         * 
         * @param source
         *        Specifies what output is prompting the agent to reprompt the input.
         * @see Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Source
         */
        Builder source(Source source);

        /**
         * <p>
         * The text reprompting the input.
         * </p>
         * 
         * @param text
         *        The text reprompting the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(RepromptResponse model) {
            source(model.source);
            text(model.text);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(Source source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public RepromptResponse build() {
            return new RepromptResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
