/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an action (operation) called by a node during execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeActionEvent implements SdkPojo, Serializable, ToCopyableBuilder<NodeActionEvent.Builder, NodeActionEvent> {
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(NodeActionEvent::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationName").getter(getter(NodeActionEvent::operationName)).setter(setter(Builder::operationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationName").build()).build();

    private static final SdkField<Document> OPERATION_REQUEST_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("operationRequest").getter(getter(NodeActionEvent::operationRequest))
            .setter(setter(Builder::operationRequest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationRequest").build()).build();

    private static final SdkField<Document> OPERATION_RESPONSE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("operationResponse").getter(getter(NodeActionEvent::operationResponse))
            .setter(setter(Builder::operationResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationResponse").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(NodeActionEvent::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(NodeActionEvent::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp")
            .getter(getter(NodeActionEvent::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_NAME_FIELD,
            OPERATION_NAME_FIELD, OPERATION_REQUEST_FIELD, OPERATION_RESPONSE_FIELD, REQUEST_ID_FIELD, SERVICE_NAME_FIELD,
            TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeName;

    private final String operationName;

    private final Document operationRequest;

    private final Document operationResponse;

    private final String requestIdValue;

    private final String serviceName;

    private final Instant timestamp;

    private NodeActionEvent(BuilderImpl builder) {
        this.nodeName = builder.nodeName;
        this.operationName = builder.operationName;
        this.operationRequest = builder.operationRequest;
        this.operationResponse = builder.operationResponse;
        this.requestIdValue = builder.requestIdValue;
        this.serviceName = builder.serviceName;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The name of the node that called the operation.
     * </p>
     * 
     * @return The name of the node that called the operation.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * The name of the operation that the node called.
     * </p>
     * 
     * @return The name of the operation that the node called.
     */
    public final String operationName() {
        return operationName;
    }

    /**
     * <p>
     * The request payload sent to the downstream service.
     * </p>
     * 
     * @return The request payload sent to the downstream service.
     */
    public final Document operationRequest() {
        return operationRequest;
    }

    /**
     * <p>
     * The response payload received from the downstream service.
     * </p>
     * 
     * @return The response payload received from the downstream service.
     */
    public final Document operationResponse() {
        return operationResponse;
    }

    /**
     * <p>
     * The ID of the request that the node made to the operation.
     * </p>
     * 
     * @return The ID of the request that the node made to the operation.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The name of the service that the node called.
     * </p>
     * 
     * @return The name of the service that the node called.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The date and time that the operation was called.
     * </p>
     * 
     * @return The date and time that the operation was called.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(operationName());
        hashCode = 31 * hashCode + Objects.hashCode(operationRequest());
        hashCode = 31 * hashCode + Objects.hashCode(operationResponse());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeActionEvent)) {
            return false;
        }
        NodeActionEvent other = (NodeActionEvent) obj;
        return Objects.equals(nodeName(), other.nodeName()) && Objects.equals(operationName(), other.operationName())
                && Objects.equals(operationRequest(), other.operationRequest())
                && Objects.equals(operationResponse(), other.operationResponse())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeActionEvent").add("NodeName", nodeName()).add("OperationName", operationName())
                .add("OperationRequest", operationRequest()).add("OperationResponse", operationResponse())
                .add("RequestId", requestId()).add("ServiceName", serviceName()).add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "operationName":
            return Optional.ofNullable(clazz.cast(operationName()));
        case "operationRequest":
            return Optional.ofNullable(clazz.cast(operationRequest()));
        case "operationResponse":
            return Optional.ofNullable(clazz.cast(operationResponse()));
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("operationName", OPERATION_NAME_FIELD);
        map.put("operationRequest", OPERATION_REQUEST_FIELD);
        map.put("operationResponse", OPERATION_RESPONSE_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeActionEvent, T> g) {
        return obj -> g.apply((NodeActionEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeActionEvent> {
        /**
         * <p>
         * The name of the node that called the operation.
         * </p>
         * 
         * @param nodeName
         *        The name of the node that called the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * The name of the operation that the node called.
         * </p>
         * 
         * @param operationName
         *        The name of the operation that the node called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationName(String operationName);

        /**
         * <p>
         * The request payload sent to the downstream service.
         * </p>
         * 
         * @param operationRequest
         *        The request payload sent to the downstream service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationRequest(Document operationRequest);

        /**
         * <p>
         * The response payload received from the downstream service.
         * </p>
         * 
         * @param operationResponse
         *        The response payload received from the downstream service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationResponse(Document operationResponse);

        /**
         * <p>
         * The ID of the request that the node made to the operation.
         * </p>
         * 
         * @param requestIdValue
         *        The ID of the request that the node made to the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The name of the service that the node called.
         * </p>
         * 
         * @param serviceName
         *        The name of the service that the node called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The date and time that the operation was called.
         * </p>
         * 
         * @param timestamp
         *        The date and time that the operation was called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String nodeName;

        private String operationName;

        private Document operationRequest;

        private Document operationResponse;

        private String requestIdValue;

        private String serviceName;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeActionEvent model) {
            nodeName(model.nodeName);
            operationName(model.operationName);
            operationRequest(model.operationRequest);
            operationResponse(model.operationResponse);
            requestId(model.requestIdValue);
            serviceName(model.serviceName);
            timestamp(model.timestamp);
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getOperationName() {
            return operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final Document getOperationRequest() {
            return operationRequest;
        }

        public final void setOperationRequest(Document operationRequest) {
            this.operationRequest = operationRequest;
        }

        @Override
        public final Builder operationRequest(Document operationRequest) {
            this.operationRequest = operationRequest;
            return this;
        }

        public final Document getOperationResponse() {
            return operationResponse;
        }

        public final void setOperationResponse(Document operationResponse) {
            this.operationResponse = operationResponse;
        }

        @Override
        public final Builder operationResponse(Document operationResponse) {
            this.operationResponse = operationResponse;
            return this;
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public NodeActionEvent build() {
            return new NodeActionEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
