/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Payload content, such as text and images, for the invocation step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvocationStepPayload implements SdkPojo, Serializable,
        ToCopyableBuilder<InvocationStepPayload.Builder, InvocationStepPayload> {
    private static final SdkField<List<BedrockSessionContentBlock>> CONTENT_BLOCKS_FIELD = SdkField
            .<List<BedrockSessionContentBlock>> builder(MarshallingType.LIST)
            .memberName("contentBlocks")
            .getter(getter(InvocationStepPayload::contentBlocks))
            .setter(setter(Builder::contentBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BedrockSessionContentBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(BedrockSessionContentBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_BLOCKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<BedrockSessionContentBlock> contentBlocks;

    private final Type type;

    private InvocationStepPayload(BuilderImpl builder) {
        this.contentBlocks = builder.contentBlocks;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContentBlocks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContentBlocks() {
        return contentBlocks != null && !(contentBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The content for the invocation step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContentBlocks} method.
     * </p>
     * 
     * @return The content for the invocation step.
     */
    public final List<BedrockSessionContentBlock> contentBlocks() {
        return contentBlocks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContentBlocks() ? contentBlocks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationStepPayload)) {
            return false;
        }
        InvocationStepPayload other = (InvocationStepPayload) obj;
        return hasContentBlocks() == other.hasContentBlocks() && Objects.equals(contentBlocks(), other.contentBlocks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvocationStepPayload")
                .add("ContentBlocks", contentBlocks() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentBlocks":
            return Optional.ofNullable(clazz.cast(contentBlocks()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #contentBlocks()} initialized to the given value.
     *
     * <p>
     * The content for the invocation step.
     * </p>
     * 
     * @param contentBlocks
     *        The content for the invocation step.
     */
    public static InvocationStepPayload fromContentBlocks(List<BedrockSessionContentBlock> contentBlocks) {
        return builder().contentBlocks(contentBlocks).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contentBlocks", CONTENT_BLOCKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvocationStepPayload, T> g) {
        return obj -> g.apply((InvocationStepPayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvocationStepPayload> {
        /**
         * <p>
         * The content for the invocation step.
         * </p>
         * 
         * @param contentBlocks
         *        The content for the invocation step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentBlocks(Collection<BedrockSessionContentBlock> contentBlocks);

        /**
         * <p>
         * The content for the invocation step.
         * </p>
         * 
         * @param contentBlocks
         *        The content for the invocation step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentBlocks(BedrockSessionContentBlock... contentBlocks);

        /**
         * <p>
         * The content for the invocation step.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.BedrockSessionContentBlock.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.BedrockSessionContentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.BedrockSessionContentBlock.Builder#build()}
         * is called immediately and its result is passed to {@link #contentBlocks(List<BedrockSessionContentBlock>)}.
         * 
         * @param contentBlocks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.BedrockSessionContentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentBlocks(java.util.Collection<BedrockSessionContentBlock>)
         */
        Builder contentBlocks(Consumer<BedrockSessionContentBlock.Builder>... contentBlocks);
    }

    static final class BuilderImpl implements Builder {
        private List<BedrockSessionContentBlock> contentBlocks = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(InvocationStepPayload model) {
            contentBlocks(model.contentBlocks);
        }

        public final List<BedrockSessionContentBlock.Builder> getContentBlocks() {
            List<BedrockSessionContentBlock.Builder> result = BedrockSessionContentBlocksCopier.copyToBuilder(this.contentBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContentBlocks(Collection<BedrockSessionContentBlock.BuilderImpl> contentBlocks) {
            Object oldValue = this.contentBlocks;
            this.contentBlocks = BedrockSessionContentBlocksCopier.copyFromBuilder(contentBlocks);
            handleUnionValueChange(Type.CONTENT_BLOCKS, oldValue, this.contentBlocks);
        }

        @Override
        public final Builder contentBlocks(Collection<BedrockSessionContentBlock> contentBlocks) {
            Object oldValue = this.contentBlocks;
            this.contentBlocks = BedrockSessionContentBlocksCopier.copy(contentBlocks);
            handleUnionValueChange(Type.CONTENT_BLOCKS, oldValue, this.contentBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentBlocks(BedrockSessionContentBlock... contentBlocks) {
            contentBlocks(Arrays.asList(contentBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentBlocks(Consumer<BedrockSessionContentBlock.Builder>... contentBlocks) {
            contentBlocks(Stream.of(contentBlocks).map(c -> BedrockSessionContentBlock.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InvocationStepPayload build() {
            return new InvocationStepPayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see InvocationStepPayload#type()
     */
    public enum Type {
        CONTENT_BLOCKS,

        UNKNOWN_TO_SDK_VERSION
    }
}
