/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an audio segment retrieved from a knowledge base, including its location and
 * transcription.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax"
 * >Retrieve response</a> – in the <code>audio</code> field
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioSegment implements SdkPojo, Serializable, ToCopyableBuilder<AudioSegment.Builder, AudioSegment> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Uri")
            .getter(getter(AudioSegment::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()).build();

    private static final SdkField<String> TRANSCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transcription").getter(getter(AudioSegment::transcription)).setter(setter(Builder::transcription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            TRANSCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String transcription;

    private AudioSegment(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.transcription = builder.transcription;
    }

    /**
     * <p>
     * The S3 URI where this specific audio segment is stored in the multimodal storage destination.
     * </p>
     * 
     * @return The S3 URI where this specific audio segment is stored in the multimodal storage destination.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The text transcription of the audio segment content.
     * </p>
     * 
     * @return The text transcription of the audio segment content.
     */
    public final String transcription() {
        return transcription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(transcription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSegment)) {
            return false;
        }
        AudioSegment other = (AudioSegment) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(transcription(), other.transcription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioSegment").add("S3Uri", s3Uri()).add("Transcription", transcription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "transcription":
            return Optional.ofNullable(clazz.cast(transcription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Uri", S3_URI_FIELD);
        map.put("transcription", TRANSCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioSegment, T> g) {
        return obj -> g.apply((AudioSegment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioSegment> {
        /**
         * <p>
         * The S3 URI where this specific audio segment is stored in the multimodal storage destination.
         * </p>
         * 
         * @param s3Uri
         *        The S3 URI where this specific audio segment is stored in the multimodal storage destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The text transcription of the audio segment content.
         * </p>
         * 
         * @param transcription
         *        The text transcription of the audio segment content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcription(String transcription);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String transcription;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSegment model) {
            s3Uri(model.s3Uri);
            transcription(model.transcription);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getTranscription() {
            return transcription;
        }

        public final void setTranscription(String transcription) {
            this.transcription = transcription;
        }

        @Override
        public final Builder transcription(String transcription) {
            this.transcription = transcription;
            return this;
        }

        @Override
        public AudioSegment build() {
            return new AudioSegment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
