/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.Usage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Metadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Metadata> {
    private static final SdkField<String> CLIENT_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestId").getter(Metadata.getter(Metadata::clientRequestId)).setter(Metadata.setter(Builder::clientRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestId").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(Metadata.getter(Metadata::endTime)).setter(Metadata.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Long> OPERATION_TOTAL_TIME_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("operationTotalTimeMs").getter(Metadata.getter(Metadata::operationTotalTimeMs)).setter(Metadata.setter(Builder::operationTotalTimeMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationTotalTimeMs").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(Metadata.getter(Metadata::startTime)).setter(Metadata.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Long> TOTAL_TIME_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalTimeMs").getter(Metadata.getter(Metadata::totalTimeMs)).setter(Metadata.setter(Builder::totalTimeMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalTimeMs").build()}).build();
    private static final SdkField<Usage> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("usage").getter(Metadata.getter(Metadata::usage)).setter(Metadata.setter(Builder::usage)).constructor(Usage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_ID_FIELD, END_TIME_FIELD, OPERATION_TOTAL_TIME_MS_FIELD, START_TIME_FIELD, TOTAL_TIME_MS_FIELD, USAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Metadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientRequestId;
    private final Instant endTime;
    private final Long operationTotalTimeMs;
    private final Instant startTime;
    private final Long totalTimeMs;
    private final Usage usage;

    private Metadata(BuilderImpl builder) {
        this.clientRequestId = builder.clientRequestId;
        this.endTime = builder.endTime;
        this.operationTotalTimeMs = builder.operationTotalTimeMs;
        this.startTime = builder.startTime;
        this.totalTimeMs = builder.totalTimeMs;
        this.usage = builder.usage;
    }

    public final String clientRequestId() {
        return this.clientRequestId;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Long operationTotalTimeMs() {
        return this.operationTotalTimeMs;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Long totalTimeMs() {
        return this.totalTimeMs;
    }

    public final Usage usage() {
        return this.usage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTotalTimeMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalTimeMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.usage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata)obj;
        return Objects.equals(this.clientRequestId(), other.clientRequestId()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.operationTotalTimeMs(), other.operationTotalTimeMs()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.totalTimeMs(), other.totalTimeMs()) && Objects.equals(this.usage(), other.usage());
    }

    public final String toString() {
        return ToString.builder((String)"Metadata").add("ClientRequestId", (Object)this.clientRequestId()).add("EndTime", (Object)this.endTime()).add("OperationTotalTimeMs", (Object)this.operationTotalTimeMs()).add("StartTime", (Object)this.startTime()).add("TotalTimeMs", (Object)this.totalTimeMs()).add("Usage", (Object)(this.usage() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientRequestId": {
                return Optional.ofNullable(clazz.cast(this.clientRequestId()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "operationTotalTimeMs": {
                return Optional.ofNullable(clazz.cast(this.operationTotalTimeMs()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "totalTimeMs": {
                return Optional.ofNullable(clazz.cast(this.totalTimeMs()));
            }
            case "usage": {
                return Optional.ofNullable(clazz.cast(this.usage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientRequestId", CLIENT_REQUEST_ID_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("operationTotalTimeMs", OPERATION_TOTAL_TIME_MS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("totalTimeMs", TOTAL_TIME_MS_FIELD);
        map.put("usage", USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Metadata, T> g) {
        return obj -> g.apply((Metadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientRequestId;
        private Instant endTime;
        private Long operationTotalTimeMs;
        private Instant startTime;
        private Long totalTimeMs;
        private Usage usage;

        private BuilderImpl() {
        }

        private BuilderImpl(Metadata model) {
            this.clientRequestId(model.clientRequestId);
            this.endTime(model.endTime);
            this.operationTotalTimeMs(model.operationTotalTimeMs);
            this.startTime(model.startTime);
            this.totalTimeMs(model.totalTimeMs);
            this.usage(model.usage);
        }

        public final String getClientRequestId() {
            return this.clientRequestId;
        }

        public final void setClientRequestId(String clientRequestId) {
            this.clientRequestId = clientRequestId;
        }

        @Override
        public final Builder clientRequestId(String clientRequestId) {
            this.clientRequestId = clientRequestId;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Long getOperationTotalTimeMs() {
            return this.operationTotalTimeMs;
        }

        public final void setOperationTotalTimeMs(Long operationTotalTimeMs) {
            this.operationTotalTimeMs = operationTotalTimeMs;
        }

        @Override
        public final Builder operationTotalTimeMs(Long operationTotalTimeMs) {
            this.operationTotalTimeMs = operationTotalTimeMs;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getTotalTimeMs() {
            return this.totalTimeMs;
        }

        public final void setTotalTimeMs(Long totalTimeMs) {
            this.totalTimeMs = totalTimeMs;
        }

        @Override
        public final Builder totalTimeMs(Long totalTimeMs) {
            this.totalTimeMs = totalTimeMs;
            return this;
        }

        public final Usage.Builder getUsage() {
            return this.usage != null ? this.usage.toBuilder() : null;
        }

        public final void setUsage(Usage.BuilderImpl usage) {
            this.usage = usage != null ? usage.build() : null;
        }

        @Override
        public final Builder usage(Usage usage) {
            this.usage = usage;
            return this;
        }

        public Metadata build() {
            return new Metadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Metadata> {
        public Builder clientRequestId(String var1);

        public Builder endTime(Instant var1);

        public Builder operationTotalTimeMs(Long var1);

        public Builder startTime(Instant var1);

        public Builder totalTimeMs(Long var1);

        public Builder usage(Usage var1);

        default public Builder usage(Consumer<Usage.Builder> usage) {
            return this.usage((Usage)((Usage.Builder)Usage.builder().applyMutation(usage)).build());
        }
    }
}

