/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.ConversationHistory;
import software.amazon.awssdk.services.bedrockagentruntime.model.InputFile;
import software.amazon.awssdk.services.bedrockagentruntime.model.InputFilesCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationResultMember;
import software.amazon.awssdk.services.bedrockagentruntime.model.PromptSessionAttributesMapCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.ReturnControlInvocationResultsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.SessionAttributesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InlineSessionState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InlineSessionState> {
    private static final SdkField<ConversationHistory> CONVERSATION_HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conversationHistory").getter(InlineSessionState.getter(InlineSessionState::conversationHistory)).setter(InlineSessionState.setter(Builder::conversationHistory)).constructor(ConversationHistory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationHistory").build()}).build();
    private static final SdkField<List<InputFile>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("files").getter(InlineSessionState.getter(InlineSessionState::files)).setter(InlineSessionState.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invocationId").getter(InlineSessionState.getter(InlineSessionState::invocationId)).setter(InlineSessionState.setter(Builder::invocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationId").build()}).build();
    private static final SdkField<Map<String, String>> PROMPT_SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("promptSessionAttributes").getter(InlineSessionState.getter(InlineSessionState::promptSessionAttributes)).setter(InlineSessionState.setter(Builder::promptSessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSessionAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<InvocationResultMember>> RETURN_CONTROL_INVOCATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("returnControlInvocationResults").getter(InlineSessionState.getter(InlineSessionState::returnControlInvocationResults)).setter(InlineSessionState.setter(Builder::returnControlInvocationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnControlInvocationResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvocationResultMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sessionAttributes").getter(InlineSessionState.getter(InlineSessionState::sessionAttributes)).setter(InlineSessionState.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_HISTORY_FIELD, FILES_FIELD, INVOCATION_ID_FIELD, PROMPT_SESSION_ATTRIBUTES_FIELD, RETURN_CONTROL_INVOCATION_RESULTS_FIELD, SESSION_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InlineSessionState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ConversationHistory conversationHistory;
    private final List<InputFile> files;
    private final String invocationId;
    private final Map<String, String> promptSessionAttributes;
    private final List<InvocationResultMember> returnControlInvocationResults;
    private final Map<String, String> sessionAttributes;

    private InlineSessionState(BuilderImpl builder) {
        this.conversationHistory = builder.conversationHistory;
        this.files = builder.files;
        this.invocationId = builder.invocationId;
        this.promptSessionAttributes = builder.promptSessionAttributes;
        this.returnControlInvocationResults = builder.returnControlInvocationResults;
        this.sessionAttributes = builder.sessionAttributes;
    }

    public final ConversationHistory conversationHistory() {
        return this.conversationHistory;
    }

    public final boolean hasFiles() {
        return this.files != null && !(this.files instanceof SdkAutoConstructList);
    }

    public final List<InputFile> files() {
        return this.files;
    }

    public final String invocationId() {
        return this.invocationId;
    }

    public final boolean hasPromptSessionAttributes() {
        return this.promptSessionAttributes != null && !(this.promptSessionAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> promptSessionAttributes() {
        return this.promptSessionAttributes;
    }

    public final boolean hasReturnControlInvocationResults() {
        return this.returnControlInvocationResults != null && !(this.returnControlInvocationResults instanceof SdkAutoConstructList);
    }

    public final List<InvocationResultMember> returnControlInvocationResults() {
        return this.returnControlInvocationResults;
    }

    public final boolean hasSessionAttributes() {
        return this.sessionAttributes != null && !(this.sessionAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sessionAttributes() {
        return this.sessionAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationHistory());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiles() ? this.files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPromptSessionAttributes() ? this.promptSessionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReturnControlInvocationResults() ? this.returnControlInvocationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionAttributes() ? this.sessionAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineSessionState)) {
            return false;
        }
        InlineSessionState other = (InlineSessionState)obj;
        return Objects.equals(this.conversationHistory(), other.conversationHistory()) && this.hasFiles() == other.hasFiles() && Objects.equals(this.files(), other.files()) && Objects.equals(this.invocationId(), other.invocationId()) && this.hasPromptSessionAttributes() == other.hasPromptSessionAttributes() && Objects.equals(this.promptSessionAttributes(), other.promptSessionAttributes()) && this.hasReturnControlInvocationResults() == other.hasReturnControlInvocationResults() && Objects.equals(this.returnControlInvocationResults(), other.returnControlInvocationResults()) && this.hasSessionAttributes() == other.hasSessionAttributes() && Objects.equals(this.sessionAttributes(), other.sessionAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"InlineSessionState").add("ConversationHistory", (Object)this.conversationHistory()).add("Files", this.hasFiles() ? this.files() : null).add("InvocationId", (Object)this.invocationId()).add("PromptSessionAttributes", this.hasPromptSessionAttributes() ? this.promptSessionAttributes() : null).add("ReturnControlInvocationResults", this.hasReturnControlInvocationResults() ? this.returnControlInvocationResults() : null).add("SessionAttributes", this.hasSessionAttributes() ? this.sessionAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conversationHistory": {
                return Optional.ofNullable(clazz.cast(this.conversationHistory()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "invocationId": {
                return Optional.ofNullable(clazz.cast(this.invocationId()));
            }
            case "promptSessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.promptSessionAttributes()));
            }
            case "returnControlInvocationResults": {
                return Optional.ofNullable(clazz.cast(this.returnControlInvocationResults()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conversationHistory", CONVERSATION_HISTORY_FIELD);
        map.put("files", FILES_FIELD);
        map.put("invocationId", INVOCATION_ID_FIELD);
        map.put("promptSessionAttributes", PROMPT_SESSION_ATTRIBUTES_FIELD);
        map.put("returnControlInvocationResults", RETURN_CONTROL_INVOCATION_RESULTS_FIELD);
        map.put("sessionAttributes", SESSION_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InlineSessionState, T> g) {
        return obj -> g.apply((InlineSessionState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConversationHistory conversationHistory;
        private List<InputFile> files = DefaultSdkAutoConstructList.getInstance();
        private String invocationId;
        private Map<String, String> promptSessionAttributes = DefaultSdkAutoConstructMap.getInstance();
        private List<InvocationResultMember> returnControlInvocationResults = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InlineSessionState model) {
            this.conversationHistory(model.conversationHistory);
            this.files(model.files);
            this.invocationId(model.invocationId);
            this.promptSessionAttributes(model.promptSessionAttributes);
            this.returnControlInvocationResults(model.returnControlInvocationResults);
            this.sessionAttributes(model.sessionAttributes);
        }

        public final ConversationHistory.Builder getConversationHistory() {
            return this.conversationHistory != null ? this.conversationHistory.toBuilder() : null;
        }

        public final void setConversationHistory(ConversationHistory.BuilderImpl conversationHistory) {
            this.conversationHistory = conversationHistory != null ? conversationHistory.build() : null;
        }

        @Override
        public final Builder conversationHistory(ConversationHistory conversationHistory) {
            this.conversationHistory = conversationHistory;
            return this;
        }

        public final List<InputFile.Builder> getFiles() {
            List<InputFile.Builder> result = InputFilesCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<InputFile.BuilderImpl> files) {
            this.files = InputFilesCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<InputFile> files) {
            this.files = InputFilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(InputFile ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<InputFile.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (InputFile)((InputFile.Builder)InputFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInvocationId() {
            return this.invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final Map<String, String> getPromptSessionAttributes() {
            if (this.promptSessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.promptSessionAttributes;
        }

        public final void setPromptSessionAttributes(Map<String, String> promptSessionAttributes) {
            this.promptSessionAttributes = PromptSessionAttributesMapCopier.copy(promptSessionAttributes);
        }

        @Override
        public final Builder promptSessionAttributes(Map<String, String> promptSessionAttributes) {
            this.promptSessionAttributes = PromptSessionAttributesMapCopier.copy(promptSessionAttributes);
            return this;
        }

        public final List<InvocationResultMember.Builder> getReturnControlInvocationResults() {
            List<InvocationResultMember.Builder> result = ReturnControlInvocationResultsCopier.copyToBuilder(this.returnControlInvocationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReturnControlInvocationResults(Collection<InvocationResultMember.BuilderImpl> returnControlInvocationResults) {
            this.returnControlInvocationResults = ReturnControlInvocationResultsCopier.copyFromBuilder(returnControlInvocationResults);
        }

        @Override
        public final Builder returnControlInvocationResults(Collection<InvocationResultMember> returnControlInvocationResults) {
            this.returnControlInvocationResults = ReturnControlInvocationResultsCopier.copy(returnControlInvocationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder returnControlInvocationResults(InvocationResultMember ... returnControlInvocationResults) {
            this.returnControlInvocationResults(Arrays.asList(returnControlInvocationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder returnControlInvocationResults(Consumer<InvocationResultMember.Builder> ... returnControlInvocationResults) {
            this.returnControlInvocationResults(Stream.of(returnControlInvocationResults).map(c -> (InvocationResultMember)((InvocationResultMember.Builder)InvocationResultMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getSessionAttributes() {
            if (this.sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sessionAttributes;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = SessionAttributesMapCopier.copy(sessionAttributes);
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = SessionAttributesMapCopier.copy(sessionAttributes);
            return this;
        }

        public InlineSessionState build() {
            return new InlineSessionState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InlineSessionState> {
        public Builder conversationHistory(ConversationHistory var1);

        default public Builder conversationHistory(Consumer<ConversationHistory.Builder> conversationHistory) {
            return this.conversationHistory((ConversationHistory)((ConversationHistory.Builder)ConversationHistory.builder().applyMutation(conversationHistory)).build());
        }

        public Builder files(Collection<InputFile> var1);

        public Builder files(InputFile ... var1);

        public Builder files(Consumer<InputFile.Builder> ... var1);

        public Builder invocationId(String var1);

        public Builder promptSessionAttributes(Map<String, String> var1);

        public Builder returnControlInvocationResults(Collection<InvocationResultMember> var1);

        public Builder returnControlInvocationResults(InvocationResultMember ... var1);

        public Builder returnControlInvocationResults(Consumer<InvocationResultMember.Builder> ... var1);

        public Builder sessionAttributes(Map<String, String> var1);
    }
}

