/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionErrorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowExecutionError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowExecutionError> {
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(FlowExecutionError.getter(FlowExecutionError::errorAsString)).setter(FlowExecutionError.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(FlowExecutionError.getter(FlowExecutionError::message)).setter(FlowExecutionError.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeName").getter(FlowExecutionError.getter(FlowExecutionError::nodeName)).setter(FlowExecutionError.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, MESSAGE_FIELD, NODE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowExecutionError.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String error;
    private final String message;
    private final String nodeName;

    private FlowExecutionError(BuilderImpl builder) {
        this.error = builder.error;
        this.message = builder.message;
        this.nodeName = builder.nodeName;
    }

    public final FlowExecutionErrorType error() {
        return FlowExecutionErrorType.fromValue(this.error);
    }

    public final String errorAsString() {
        return this.error;
    }

    public final String message() {
        return this.message;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowExecutionError)) {
            return false;
        }
        FlowExecutionError other = (FlowExecutionError)obj;
        return Objects.equals(this.errorAsString(), other.errorAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.nodeName(), other.nodeName());
    }

    public final String toString() {
        return ToString.builder((String)"FlowExecutionError").add("Error", (Object)this.errorAsString()).add("Message", (Object)this.message()).add("NodeName", (Object)this.nodeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "error": {
                return Optional.ofNullable(clazz.cast(this.errorAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "nodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("error", ERROR_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("nodeName", NODE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowExecutionError, T> g) {
        return obj -> g.apply((FlowExecutionError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String error;
        private String message;
        private String nodeName;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowExecutionError model) {
            this.error(model.error);
            this.message(model.message);
            this.nodeName(model.nodeName);
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public final Builder error(FlowExecutionErrorType error) {
            this.error(error == null ? null : error.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public FlowExecutionError build() {
            return new FlowExecutionError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowExecutionError> {
        public Builder error(String var1);

        public Builder error(FlowExecutionErrorType var1);

        public Builder message(String var1);

        public Builder nodeName(String var1);
    }
}

