/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.QueryGenerationInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.TransformationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateQueryRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, GenerateQueryRequest> {
    private static final SdkField<QueryGenerationInput> QUERY_GENERATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("queryGenerationInput").getter(GenerateQueryRequest.getter(GenerateQueryRequest::queryGenerationInput)).setter(GenerateQueryRequest.setter(Builder::queryGenerationInput)).constructor(QueryGenerationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryGenerationInput").build()}).build();
    private static final SdkField<TransformationConfiguration> TRANSFORMATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("transformationConfiguration").getter(GenerateQueryRequest.getter(GenerateQueryRequest::transformationConfiguration)).setter(GenerateQueryRequest.setter(Builder::transformationConfiguration)).constructor(TransformationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_GENERATION_INPUT_FIELD, TRANSFORMATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerateQueryRequest.memberNameToFieldInitializer();
    private final QueryGenerationInput queryGenerationInput;
    private final TransformationConfiguration transformationConfiguration;

    private GenerateQueryRequest(BuilderImpl builder) {
        super(builder);
        this.queryGenerationInput = builder.queryGenerationInput;
        this.transformationConfiguration = builder.transformationConfiguration;
    }

    public final QueryGenerationInput queryGenerationInput() {
        return this.queryGenerationInput;
    }

    public final TransformationConfiguration transformationConfiguration() {
        return this.transformationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryGenerationInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateQueryRequest)) {
            return false;
        }
        GenerateQueryRequest other = (GenerateQueryRequest)((Object)obj);
        return Objects.equals(this.queryGenerationInput(), other.queryGenerationInput()) && Objects.equals(this.transformationConfiguration(), other.transformationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateQueryRequest").add("QueryGenerationInput", (Object)(this.queryGenerationInput() == null ? null : "*** Sensitive Data Redacted ***")).add("TransformationConfiguration", (Object)this.transformationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queryGenerationInput": {
                return Optional.ofNullable(clazz.cast(this.queryGenerationInput()));
            }
            case "transformationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.transformationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queryGenerationInput", QUERY_GENERATION_INPUT_FIELD);
        map.put("transformationConfiguration", TRANSFORMATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateQueryRequest, T> g) {
        return obj -> g.apply((GenerateQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private QueryGenerationInput queryGenerationInput;
        private TransformationConfiguration transformationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateQueryRequest model) {
            super(model);
            this.queryGenerationInput(model.queryGenerationInput);
            this.transformationConfiguration(model.transformationConfiguration);
        }

        public final QueryGenerationInput.Builder getQueryGenerationInput() {
            return this.queryGenerationInput != null ? this.queryGenerationInput.toBuilder() : null;
        }

        public final void setQueryGenerationInput(QueryGenerationInput.BuilderImpl queryGenerationInput) {
            this.queryGenerationInput = queryGenerationInput != null ? queryGenerationInput.build() : null;
        }

        @Override
        public final Builder queryGenerationInput(QueryGenerationInput queryGenerationInput) {
            this.queryGenerationInput = queryGenerationInput;
            return this;
        }

        public final TransformationConfiguration.Builder getTransformationConfiguration() {
            return this.transformationConfiguration != null ? this.transformationConfiguration.toBuilder() : null;
        }

        public final void setTransformationConfiguration(TransformationConfiguration.BuilderImpl transformationConfiguration) {
            this.transformationConfiguration = transformationConfiguration != null ? transformationConfiguration.build() : null;
        }

        @Override
        public final Builder transformationConfiguration(TransformationConfiguration transformationConfiguration) {
            this.transformationConfiguration = transformationConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateQueryRequest build() {
            return new GenerateQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateQueryRequest> {
        public Builder queryGenerationInput(QueryGenerationInput var1);

        default public Builder queryGenerationInput(Consumer<QueryGenerationInput.Builder> queryGenerationInput) {
            return this.queryGenerationInput((QueryGenerationInput)((QueryGenerationInput.Builder)QueryGenerationInput.builder().applyMutation(queryGenerationInput)).build());
        }

        public Builder transformationConfiguration(TransformationConfiguration var1);

        default public Builder transformationConfiguration(Consumer<TransformationConfiguration.Builder> transformationConfiguration) {
            return this.transformationConfiguration((TransformationConfiguration)((TransformationConfiguration.Builder)TransformationConfiguration.builder().applyMutation(transformationConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

