/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailContentPolicyAssessment;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailSensitiveInformationPolicyAssessment;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailTopicPolicyAssessment;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailWordPolicyAssessment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailAssessment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailAssessment> {
    private static final SdkField<GuardrailContentPolicyAssessment> CONTENT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentPolicy").getter(GuardrailAssessment.getter(GuardrailAssessment::contentPolicy)).setter(GuardrailAssessment.setter(Builder::contentPolicy)).constructor(GuardrailContentPolicyAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicy").build()}).build();
    private static final SdkField<GuardrailSensitiveInformationPolicyAssessment> SENSITIVE_INFORMATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sensitiveInformationPolicy").getter(GuardrailAssessment.getter(GuardrailAssessment::sensitiveInformationPolicy)).setter(GuardrailAssessment.setter(Builder::sensitiveInformationPolicy)).constructor(GuardrailSensitiveInformationPolicyAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicy").build()}).build();
    private static final SdkField<GuardrailTopicPolicyAssessment> TOPIC_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("topicPolicy").getter(GuardrailAssessment.getter(GuardrailAssessment::topicPolicy)).setter(GuardrailAssessment.setter(Builder::topicPolicy)).constructor(GuardrailTopicPolicyAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicy").build()}).build();
    private static final SdkField<GuardrailWordPolicyAssessment> WORD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("wordPolicy").getter(GuardrailAssessment.getter(GuardrailAssessment::wordPolicy)).setter(GuardrailAssessment.setter(Builder::wordPolicy)).constructor(GuardrailWordPolicyAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_POLICY_FIELD, SENSITIVE_INFORMATION_POLICY_FIELD, TOPIC_POLICY_FIELD, WORD_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailAssessment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GuardrailContentPolicyAssessment contentPolicy;
    private final GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy;
    private final GuardrailTopicPolicyAssessment topicPolicy;
    private final GuardrailWordPolicyAssessment wordPolicy;

    private GuardrailAssessment(BuilderImpl builder) {
        this.contentPolicy = builder.contentPolicy;
        this.sensitiveInformationPolicy = builder.sensitiveInformationPolicy;
        this.topicPolicy = builder.topicPolicy;
        this.wordPolicy = builder.wordPolicy;
    }

    public final GuardrailContentPolicyAssessment contentPolicy() {
        return this.contentPolicy;
    }

    public final GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy() {
        return this.sensitiveInformationPolicy;
    }

    public final GuardrailTopicPolicyAssessment topicPolicy() {
        return this.topicPolicy;
    }

    public final GuardrailWordPolicyAssessment wordPolicy() {
        return this.wordPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitiveInformationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.wordPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAssessment)) {
            return false;
        }
        GuardrailAssessment other = (GuardrailAssessment)obj;
        return Objects.equals(this.contentPolicy(), other.contentPolicy()) && Objects.equals(this.sensitiveInformationPolicy(), other.sensitiveInformationPolicy()) && Objects.equals(this.topicPolicy(), other.topicPolicy()) && Objects.equals(this.wordPolicy(), other.wordPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailAssessment").add("ContentPolicy", (Object)(this.contentPolicy() == null ? null : "*** Sensitive Data Redacted ***")).add("SensitiveInformationPolicy", (Object)(this.sensitiveInformationPolicy() == null ? null : "*** Sensitive Data Redacted ***")).add("TopicPolicy", (Object)(this.topicPolicy() == null ? null : "*** Sensitive Data Redacted ***")).add("WordPolicy", (Object)(this.wordPolicy() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentPolicy": {
                return Optional.ofNullable(clazz.cast(this.contentPolicy()));
            }
            case "sensitiveInformationPolicy": {
                return Optional.ofNullable(clazz.cast(this.sensitiveInformationPolicy()));
            }
            case "topicPolicy": {
                return Optional.ofNullable(clazz.cast(this.topicPolicy()));
            }
            case "wordPolicy": {
                return Optional.ofNullable(clazz.cast(this.wordPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contentPolicy", CONTENT_POLICY_FIELD);
        map.put("sensitiveInformationPolicy", SENSITIVE_INFORMATION_POLICY_FIELD);
        map.put("topicPolicy", TOPIC_POLICY_FIELD);
        map.put("wordPolicy", WORD_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAssessment, T> g) {
        return obj -> g.apply((GuardrailAssessment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GuardrailContentPolicyAssessment contentPolicy;
        private GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy;
        private GuardrailTopicPolicyAssessment topicPolicy;
        private GuardrailWordPolicyAssessment wordPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAssessment model) {
            this.contentPolicy(model.contentPolicy);
            this.sensitiveInformationPolicy(model.sensitiveInformationPolicy);
            this.topicPolicy(model.topicPolicy);
            this.wordPolicy(model.wordPolicy);
        }

        public final GuardrailContentPolicyAssessment.Builder getContentPolicy() {
            return this.contentPolicy != null ? this.contentPolicy.toBuilder() : null;
        }

        public final void setContentPolicy(GuardrailContentPolicyAssessment.BuilderImpl contentPolicy) {
            this.contentPolicy = contentPolicy != null ? contentPolicy.build() : null;
        }

        @Override
        public final Builder contentPolicy(GuardrailContentPolicyAssessment contentPolicy) {
            this.contentPolicy = contentPolicy;
            return this;
        }

        public final GuardrailSensitiveInformationPolicyAssessment.Builder getSensitiveInformationPolicy() {
            return this.sensitiveInformationPolicy != null ? this.sensitiveInformationPolicy.toBuilder() : null;
        }

        public final void setSensitiveInformationPolicy(GuardrailSensitiveInformationPolicyAssessment.BuilderImpl sensitiveInformationPolicy) {
            this.sensitiveInformationPolicy = sensitiveInformationPolicy != null ? sensitiveInformationPolicy.build() : null;
        }

        @Override
        public final Builder sensitiveInformationPolicy(GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy) {
            this.sensitiveInformationPolicy = sensitiveInformationPolicy;
            return this;
        }

        public final GuardrailTopicPolicyAssessment.Builder getTopicPolicy() {
            return this.topicPolicy != null ? this.topicPolicy.toBuilder() : null;
        }

        public final void setTopicPolicy(GuardrailTopicPolicyAssessment.BuilderImpl topicPolicy) {
            this.topicPolicy = topicPolicy != null ? topicPolicy.build() : null;
        }

        @Override
        public final Builder topicPolicy(GuardrailTopicPolicyAssessment topicPolicy) {
            this.topicPolicy = topicPolicy;
            return this;
        }

        public final GuardrailWordPolicyAssessment.Builder getWordPolicy() {
            return this.wordPolicy != null ? this.wordPolicy.toBuilder() : null;
        }

        public final void setWordPolicy(GuardrailWordPolicyAssessment.BuilderImpl wordPolicy) {
            this.wordPolicy = wordPolicy != null ? wordPolicy.build() : null;
        }

        @Override
        public final Builder wordPolicy(GuardrailWordPolicyAssessment wordPolicy) {
            this.wordPolicy = wordPolicy;
            return this;
        }

        public GuardrailAssessment build() {
            return new GuardrailAssessment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailAssessment> {
        public Builder contentPolicy(GuardrailContentPolicyAssessment var1);

        default public Builder contentPolicy(Consumer<GuardrailContentPolicyAssessment.Builder> contentPolicy) {
            return this.contentPolicy((GuardrailContentPolicyAssessment)((GuardrailContentPolicyAssessment.Builder)GuardrailContentPolicyAssessment.builder().applyMutation(contentPolicy)).build());
        }

        public Builder sensitiveInformationPolicy(GuardrailSensitiveInformationPolicyAssessment var1);

        default public Builder sensitiveInformationPolicy(Consumer<GuardrailSensitiveInformationPolicyAssessment.Builder> sensitiveInformationPolicy) {
            return this.sensitiveInformationPolicy((GuardrailSensitiveInformationPolicyAssessment)((GuardrailSensitiveInformationPolicyAssessment.Builder)GuardrailSensitiveInformationPolicyAssessment.builder().applyMutation(sensitiveInformationPolicy)).build());
        }

        public Builder topicPolicy(GuardrailTopicPolicyAssessment var1);

        default public Builder topicPolicy(Consumer<GuardrailTopicPolicyAssessment.Builder> topicPolicy) {
            return this.topicPolicy((GuardrailTopicPolicyAssessment)((GuardrailTopicPolicyAssessment.Builder)GuardrailTopicPolicyAssessment.builder().applyMutation(topicPolicy)).build());
        }

        public Builder wordPolicy(GuardrailWordPolicyAssessment var1);

        default public Builder wordPolicy(Consumer<GuardrailWordPolicyAssessment.Builder> wordPolicy) {
            return this.wordPolicy((GuardrailWordPolicyAssessment)((GuardrailWordPolicyAssessment.Builder)GuardrailWordPolicyAssessment.builder().applyMutation(wordPolicy)).build());
        }
    }
}

