/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentResponseStream;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeInlineAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.OutputFile;
import software.amazon.awssdk.services.bedrockagentruntime.model.OutputFilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InlineAgentFilePart
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InlineAgentFilePart>,
InlineAgentResponseStream {
    private static final SdkField<List<OutputFile>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("files").getter(InlineAgentFilePart.getter(InlineAgentFilePart::files)).setter(InlineAgentFilePart.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InlineAgentFilePart.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<OutputFile> files;

    protected InlineAgentFilePart(BuilderImpl builder) {
        this.files = builder.files;
    }

    public final boolean hasFiles() {
        return this.files != null && !(this.files instanceof SdkAutoConstructList);
    }

    public final List<OutputFile> files() {
        return this.files;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiles() ? this.files() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineAgentFilePart)) {
            return false;
        }
        InlineAgentFilePart other = (InlineAgentFilePart)obj;
        return this.hasFiles() == other.hasFiles() && Objects.equals(this.files(), other.files());
    }

    public final String toString() {
        return ToString.builder((String)"InlineAgentFilePart").add("Files", (Object)(this.files() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
        }
        return Optional.empty();
    }

    public final InlineAgentFilePart copy(Consumer<? super Builder> modifier) {
        return (InlineAgentFilePart)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<OutputFile>>> map = new HashMap<String, SdkField<List<OutputFile>>>();
        map.put("files", FILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InlineAgentFilePart, T> g) {
        return obj -> g.apply((InlineAgentFilePart)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(InvokeInlineAgentResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private List<OutputFile> files = DefaultSdkAutoConstructList.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(InlineAgentFilePart model) {
            this.files(model.files);
        }

        public final List<OutputFile.Builder> getFiles() {
            List<OutputFile.Builder> result = OutputFilesCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<OutputFile.BuilderImpl> files) {
            this.files = OutputFilesCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<OutputFile> files) {
            this.files = OutputFilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(OutputFile ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<OutputFile.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (OutputFile)((OutputFile.Builder)OutputFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InlineAgentFilePart build() {
            return new InlineAgentFilePart(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InlineAgentFilePart> {
        public Builder files(Collection<OutputFile> var1);

        public Builder files(OutputFile ... var1);

        public Builder files(Consumer<OutputFile.Builder> ... var1);
    }
}

