/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GuardrailContentFilterType {
    INSULTS("INSULTS"),
    HATE("HATE"),
    SEXUAL("SEXUAL"),
    VIOLENCE("VIOLENCE"),
    MISCONDUCT("MISCONDUCT"),
    PROMPT_ATTACK("PROMPT_ATTACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GuardrailContentFilterType> VALUE_MAP;
    private final String value;

    private GuardrailContentFilterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GuardrailContentFilterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GuardrailContentFilterType> knownValues() {
        EnumSet<GuardrailContentFilterType> knownValues = EnumSet.allOf(GuardrailContentFilterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GuardrailContentFilterType.class, GuardrailContentFilterType::toString);
    }
}

