/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateSessionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveAndGenerateStreamRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, RetrieveAndGenerateStreamRequest> {
    private static final SdkField<RetrieveAndGenerateInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("input").getter(RetrieveAndGenerateStreamRequest.getter(RetrieveAndGenerateStreamRequest::input)).setter(RetrieveAndGenerateStreamRequest.setter(Builder::input)).constructor(RetrieveAndGenerateInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<RetrieveAndGenerateConfiguration> RETRIEVE_AND_GENERATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retrieveAndGenerateConfiguration").getter(RetrieveAndGenerateStreamRequest.getter(RetrieveAndGenerateStreamRequest::retrieveAndGenerateConfiguration)).setter(RetrieveAndGenerateStreamRequest.setter(Builder::retrieveAndGenerateConfiguration)).constructor(RetrieveAndGenerateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieveAndGenerateConfiguration").build()}).build();
    private static final SdkField<RetrieveAndGenerateSessionConfiguration> SESSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionConfiguration").getter(RetrieveAndGenerateStreamRequest.getter(RetrieveAndGenerateStreamRequest::sessionConfiguration)).setter(RetrieveAndGenerateStreamRequest.setter(Builder::sessionConfiguration)).constructor(RetrieveAndGenerateSessionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionConfiguration").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(RetrieveAndGenerateStreamRequest.getter(RetrieveAndGenerateStreamRequest::sessionId)).setter(RetrieveAndGenerateStreamRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, RETRIEVE_AND_GENERATE_CONFIGURATION_FIELD, SESSION_CONFIGURATION_FIELD, SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("input", INPUT_FIELD);
            this.put("retrieveAndGenerateConfiguration", RETRIEVE_AND_GENERATE_CONFIGURATION_FIELD);
            this.put("sessionConfiguration", SESSION_CONFIGURATION_FIELD);
            this.put("sessionId", SESSION_ID_FIELD);
        }
    });
    private final RetrieveAndGenerateInput input;
    private final RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration;
    private final RetrieveAndGenerateSessionConfiguration sessionConfiguration;
    private final String sessionId;

    private RetrieveAndGenerateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.input = builder.input;
        this.retrieveAndGenerateConfiguration = builder.retrieveAndGenerateConfiguration;
        this.sessionConfiguration = builder.sessionConfiguration;
        this.sessionId = builder.sessionId;
    }

    public final RetrieveAndGenerateInput input() {
        return this.input;
    }

    public final RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration() {
        return this.retrieveAndGenerateConfiguration;
    }

    public final RetrieveAndGenerateSessionConfiguration sessionConfiguration() {
        return this.sessionConfiguration;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrieveAndGenerateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveAndGenerateStreamRequest)) {
            return false;
        }
        RetrieveAndGenerateStreamRequest other = (RetrieveAndGenerateStreamRequest)((Object)obj);
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.retrieveAndGenerateConfiguration(), other.retrieveAndGenerateConfiguration()) && Objects.equals(this.sessionConfiguration(), other.sessionConfiguration()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveAndGenerateStreamRequest").add("Input", (Object)(this.input() == null ? null : "*** Sensitive Data Redacted ***")).add("RetrieveAndGenerateConfiguration", (Object)this.retrieveAndGenerateConfiguration()).add("SessionConfiguration", (Object)this.sessionConfiguration()).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "retrieveAndGenerateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.retrieveAndGenerateConfiguration()));
            }
            case "sessionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sessionConfiguration()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveAndGenerateStreamRequest, T> g) {
        return obj -> g.apply((RetrieveAndGenerateStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private RetrieveAndGenerateInput input;
        private RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration;
        private RetrieveAndGenerateSessionConfiguration sessionConfiguration;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveAndGenerateStreamRequest model) {
            super(model);
            this.input(model.input);
            this.retrieveAndGenerateConfiguration(model.retrieveAndGenerateConfiguration);
            this.sessionConfiguration(model.sessionConfiguration);
            this.sessionId(model.sessionId);
        }

        public final RetrieveAndGenerateInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(RetrieveAndGenerateInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(RetrieveAndGenerateInput input) {
            this.input = input;
            return this;
        }

        public final RetrieveAndGenerateConfiguration.Builder getRetrieveAndGenerateConfiguration() {
            return this.retrieveAndGenerateConfiguration != null ? this.retrieveAndGenerateConfiguration.toBuilder() : null;
        }

        public final void setRetrieveAndGenerateConfiguration(RetrieveAndGenerateConfiguration.BuilderImpl retrieveAndGenerateConfiguration) {
            this.retrieveAndGenerateConfiguration = retrieveAndGenerateConfiguration != null ? retrieveAndGenerateConfiguration.build() : null;
        }

        @Override
        public final Builder retrieveAndGenerateConfiguration(RetrieveAndGenerateConfiguration retrieveAndGenerateConfiguration) {
            this.retrieveAndGenerateConfiguration = retrieveAndGenerateConfiguration;
            return this;
        }

        public final RetrieveAndGenerateSessionConfiguration.Builder getSessionConfiguration() {
            return this.sessionConfiguration != null ? this.sessionConfiguration.toBuilder() : null;
        }

        public final void setSessionConfiguration(RetrieveAndGenerateSessionConfiguration.BuilderImpl sessionConfiguration) {
            this.sessionConfiguration = sessionConfiguration != null ? sessionConfiguration.build() : null;
        }

        @Override
        public final Builder sessionConfiguration(RetrieveAndGenerateSessionConfiguration sessionConfiguration) {
            this.sessionConfiguration = sessionConfiguration;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetrieveAndGenerateStreamRequest build() {
            return new RetrieveAndGenerateStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetrieveAndGenerateStreamRequest> {
        public Builder input(RetrieveAndGenerateInput var1);

        default public Builder input(Consumer<RetrieveAndGenerateInput.Builder> input) {
            return this.input((RetrieveAndGenerateInput)((RetrieveAndGenerateInput.Builder)RetrieveAndGenerateInput.builder().applyMutation(input)).build());
        }

        public Builder retrieveAndGenerateConfiguration(RetrieveAndGenerateConfiguration var1);

        default public Builder retrieveAndGenerateConfiguration(Consumer<RetrieveAndGenerateConfiguration.Builder> retrieveAndGenerateConfiguration) {
            return this.retrieveAndGenerateConfiguration((RetrieveAndGenerateConfiguration)((RetrieveAndGenerateConfiguration.Builder)RetrieveAndGenerateConfiguration.builder().applyMutation(retrieveAndGenerateConfiguration)).build());
        }

        public Builder sessionConfiguration(RetrieveAndGenerateSessionConfiguration var1);

        default public Builder sessionConfiguration(Consumer<RetrieveAndGenerateSessionConfiguration.Builder> sessionConfiguration) {
            return this.sessionConfiguration((RetrieveAndGenerateSessionConfiguration)((RetrieveAndGenerateSessionConfiguration.Builder)RetrieveAndGenerateSessionConfiguration.builder().applyMutation(sessionConfiguration)).build());
        }

        public Builder sessionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

