/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankDocumentType;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankTextDocument;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RerankDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RerankDocument> {
    private static final SdkField<Document> JSON_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("jsonDocument").getter(RerankDocument.getter(RerankDocument::jsonDocument)).setter(RerankDocument.setter(Builder::jsonDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonDocument").build()}).build();
    private static final SdkField<RerankTextDocument> TEXT_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("textDocument").getter(RerankDocument.getter(RerankDocument::textDocument)).setter(RerankDocument.setter(Builder::textDocument)).constructor(RerankTextDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textDocument").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RerankDocument.getter(RerankDocument::typeAsString)).setter(RerankDocument.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_DOCUMENT_FIELD, TEXT_DOCUMENT_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("jsonDocument", JSON_DOCUMENT_FIELD);
            this.put("textDocument", TEXT_DOCUMENT_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Document jsonDocument;
    private final RerankTextDocument textDocument;
    private final String type;

    private RerankDocument(BuilderImpl builder) {
        this.jsonDocument = builder.jsonDocument;
        this.textDocument = builder.textDocument;
        this.type = builder.type;
    }

    public final Document jsonDocument() {
        return this.jsonDocument;
    }

    public final RerankTextDocument textDocument() {
        return this.textDocument;
    }

    public final RerankDocumentType type() {
        return RerankDocumentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.textDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RerankDocument)) {
            return false;
        }
        RerankDocument other = (RerankDocument)obj;
        return Objects.equals(this.jsonDocument(), other.jsonDocument()) && Objects.equals(this.textDocument(), other.textDocument()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RerankDocument").add("JsonDocument", (Object)this.jsonDocument()).add("TextDocument", (Object)(this.textDocument() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jsonDocument": {
                return Optional.ofNullable(clazz.cast(this.jsonDocument()));
            }
            case "textDocument": {
                return Optional.ofNullable(clazz.cast(this.textDocument()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RerankDocument, T> g) {
        return obj -> g.apply((RerankDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Document jsonDocument;
        private RerankTextDocument textDocument;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RerankDocument model) {
            this.jsonDocument(model.jsonDocument);
            this.textDocument(model.textDocument);
            this.type(model.type);
        }

        public final Document getJsonDocument() {
            return this.jsonDocument;
        }

        public final void setJsonDocument(Document jsonDocument) {
            this.jsonDocument = jsonDocument;
        }

        @Override
        public final Builder jsonDocument(Document jsonDocument) {
            this.jsonDocument = jsonDocument;
            return this;
        }

        public final RerankTextDocument.Builder getTextDocument() {
            return this.textDocument != null ? this.textDocument.toBuilder() : null;
        }

        public final void setTextDocument(RerankTextDocument.BuilderImpl textDocument) {
            this.textDocument = textDocument != null ? textDocument.build() : null;
        }

        @Override
        public final Builder textDocument(RerankTextDocument textDocument) {
            this.textDocument = textDocument;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RerankDocumentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RerankDocument build() {
            return new RerankDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RerankDocument> {
        public Builder jsonDocument(Document var1);

        public Builder textDocument(RerankTextDocument var1);

        default public Builder textDocument(Consumer<RerankTextDocument.Builder> textDocument) {
            return this.textDocument((RerankTextDocument)((RerankTextDocument.Builder)RerankTextDocument.builder().applyMutation(textDocument)).build());
        }

        public Builder type(String var1);

        public Builder type(RerankDocumentType var1);
    }
}

