/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.StopSequencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceConfiguration> {
    private static final SdkField<Integer> MAXIMUM_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumLength").getter(InferenceConfiguration.getter(InferenceConfiguration::maximumLength)).setter(InferenceConfiguration.setter(Builder::maximumLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumLength").build()}).build();
    private static final SdkField<List<String>> STOP_SEQUENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stopSequences").getter(InferenceConfiguration.getter(InferenceConfiguration::stopSequences)).setter(InferenceConfiguration.setter(Builder::stopSequences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopSequences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> TEMPERATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("temperature").getter(InferenceConfiguration.getter(InferenceConfiguration::temperature)).setter(InferenceConfiguration.setter(Builder::temperature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temperature").build()}).build();
    private static final SdkField<Integer> TOPK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("topK").getter(InferenceConfiguration.getter(InferenceConfiguration::topK)).setter(InferenceConfiguration.setter(Builder::topK)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topK").build()}).build();
    private static final SdkField<Float> TOPP_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("topP").getter(InferenceConfiguration.getter(InferenceConfiguration::topP)).setter(InferenceConfiguration.setter(Builder::topP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topP").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_LENGTH_FIELD, STOP_SEQUENCES_FIELD, TEMPERATURE_FIELD, TOPK_FIELD, TOPP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("maximumLength", MAXIMUM_LENGTH_FIELD);
            this.put("stopSequences", STOP_SEQUENCES_FIELD);
            this.put("temperature", TEMPERATURE_FIELD);
            this.put("topK", TOPK_FIELD);
            this.put("topP", TOPP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer maximumLength;
    private final List<String> stopSequences;
    private final Float temperature;
    private final Integer topK;
    private final Float topP;

    private InferenceConfiguration(BuilderImpl builder) {
        this.maximumLength = builder.maximumLength;
        this.stopSequences = builder.stopSequences;
        this.temperature = builder.temperature;
        this.topK = builder.topK;
        this.topP = builder.topP;
    }

    public final Integer maximumLength() {
        return this.maximumLength;
    }

    public final boolean hasStopSequences() {
        return this.stopSequences != null && !(this.stopSequences instanceof SdkAutoConstructList);
    }

    public final List<String> stopSequences() {
        return this.stopSequences;
    }

    public final Float temperature() {
        return this.temperature;
    }

    public final Integer topK() {
        return this.topK;
    }

    public final Float topP() {
        return this.topP;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStopSequences() ? this.stopSequences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.temperature());
        hashCode = 31 * hashCode + Objects.hashCode(this.topK());
        hashCode = 31 * hashCode + Objects.hashCode(this.topP());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceConfiguration)) {
            return false;
        }
        InferenceConfiguration other = (InferenceConfiguration)obj;
        return Objects.equals(this.maximumLength(), other.maximumLength()) && this.hasStopSequences() == other.hasStopSequences() && Objects.equals(this.stopSequences(), other.stopSequences()) && Objects.equals(this.temperature(), other.temperature()) && Objects.equals(this.topK(), other.topK()) && Objects.equals(this.topP(), other.topP());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceConfiguration").add("MaximumLength", (Object)this.maximumLength()).add("StopSequences", this.hasStopSequences() ? this.stopSequences() : null).add("Temperature", (Object)this.temperature()).add("TopK", (Object)this.topK()).add("TopP", (Object)this.topP()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maximumLength": {
                return Optional.ofNullable(clazz.cast(this.maximumLength()));
            }
            case "stopSequences": {
                return Optional.ofNullable(clazz.cast(this.stopSequences()));
            }
            case "temperature": {
                return Optional.ofNullable(clazz.cast(this.temperature()));
            }
            case "topK": {
                return Optional.ofNullable(clazz.cast(this.topK()));
            }
            case "topP": {
                return Optional.ofNullable(clazz.cast(this.topP()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InferenceConfiguration, T> g) {
        return obj -> g.apply((InferenceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maximumLength;
        private List<String> stopSequences = DefaultSdkAutoConstructList.getInstance();
        private Float temperature;
        private Integer topK;
        private Float topP;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceConfiguration model) {
            this.maximumLength(model.maximumLength);
            this.stopSequences(model.stopSequences);
            this.temperature(model.temperature);
            this.topK(model.topK);
            this.topP(model.topP);
        }

        public final Integer getMaximumLength() {
            return this.maximumLength;
        }

        public final void setMaximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
        }

        @Override
        public final Builder maximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public final Collection<String> getStopSequences() {
            if (this.stopSequences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stopSequences;
        }

        public final void setStopSequences(Collection<String> stopSequences) {
            this.stopSequences = StopSequencesCopier.copy(stopSequences);
        }

        @Override
        public final Builder stopSequences(Collection<String> stopSequences) {
            this.stopSequences = StopSequencesCopier.copy(stopSequences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopSequences(String ... stopSequences) {
            this.stopSequences(Arrays.asList(stopSequences));
            return this;
        }

        public final Float getTemperature() {
            return this.temperature;
        }

        public final void setTemperature(Float temperature) {
            this.temperature = temperature;
        }

        @Override
        public final Builder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public final Integer getTopK() {
            return this.topK;
        }

        public final void setTopK(Integer topK) {
            this.topK = topK;
        }

        @Override
        public final Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public final Float getTopP() {
            return this.topP;
        }

        public final void setTopP(Float topP) {
            this.topP = topP;
        }

        @Override
        public final Builder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        public InferenceConfiguration build() {
            return new InferenceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceConfiguration> {
        public Builder maximumLength(Integer var1);

        public Builder stopSequences(Collection<String> var1);

        public Builder stopSequences(String ... var1);

        public Builder temperature(Float var1);

        public Builder topK(Integer var1);

        public Builder topP(Float var1);
    }
}

