/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseQuery;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseRetrievalConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, RetrieveRequest> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(RetrieveRequest.getter(RetrieveRequest::knowledgeBaseId)).setter(RetrieveRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(RetrieveRequest.getter(RetrieveRequest::nextToken)).setter(RetrieveRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<KnowledgeBaseRetrievalConfiguration> RETRIEVAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retrievalConfiguration").getter(RetrieveRequest.getter(RetrieveRequest::retrievalConfiguration)).setter(RetrieveRequest.setter(Builder::retrievalConfiguration)).constructor(KnowledgeBaseRetrievalConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalConfiguration").build()}).build();
    private static final SdkField<KnowledgeBaseQuery> RETRIEVAL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retrievalQuery").getter(RetrieveRequest.getter(RetrieveRequest::retrievalQuery)).setter(RetrieveRequest.setter(Builder::retrievalQuery)).constructor(KnowledgeBaseQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalQuery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, NEXT_TOKEN_FIELD, RETRIEVAL_CONFIGURATION_FIELD, RETRIEVAL_QUERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("retrievalConfiguration", RETRIEVAL_CONFIGURATION_FIELD);
            this.put("retrievalQuery", RETRIEVAL_QUERY_FIELD);
        }
    });
    private final String knowledgeBaseId;
    private final String nextToken;
    private final KnowledgeBaseRetrievalConfiguration retrievalConfiguration;
    private final KnowledgeBaseQuery retrievalQuery;

    private RetrieveRequest(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.nextToken = builder.nextToken;
        this.retrievalConfiguration = builder.retrievalConfiguration;
        this.retrievalQuery = builder.retrievalQuery;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final KnowledgeBaseRetrievalConfiguration retrievalConfiguration() {
        return this.retrievalConfiguration;
    }

    public final KnowledgeBaseQuery retrievalQuery() {
        return this.retrievalQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalQuery());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveRequest)) {
            return false;
        }
        RetrieveRequest other = (RetrieveRequest)((Object)obj);
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.retrievalConfiguration(), other.retrievalConfiguration()) && Objects.equals(this.retrievalQuery(), other.retrievalQuery());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveRequest").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("NextToken", (Object)this.nextToken()).add("RetrievalConfiguration", (Object)this.retrievalConfiguration()).add("RetrievalQuery", (Object)(this.retrievalQuery() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "retrievalConfiguration": {
                return Optional.ofNullable(clazz.cast(this.retrievalConfiguration()));
            }
            case "retrievalQuery": {
                return Optional.ofNullable(clazz.cast(this.retrievalQuery()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveRequest, T> g) {
        return obj -> g.apply((RetrieveRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private String nextToken;
        private KnowledgeBaseRetrievalConfiguration retrievalConfiguration;
        private KnowledgeBaseQuery retrievalQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveRequest model) {
            super(model);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.nextToken(model.nextToken);
            this.retrievalConfiguration(model.retrievalConfiguration);
            this.retrievalQuery(model.retrievalQuery);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final KnowledgeBaseRetrievalConfiguration.Builder getRetrievalConfiguration() {
            return this.retrievalConfiguration != null ? this.retrievalConfiguration.toBuilder() : null;
        }

        public final void setRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration.BuilderImpl retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration != null ? retrievalConfiguration.build() : null;
        }

        @Override
        public final Builder retrievalConfiguration(KnowledgeBaseRetrievalConfiguration retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration;
            return this;
        }

        public final KnowledgeBaseQuery.Builder getRetrievalQuery() {
            return this.retrievalQuery != null ? this.retrievalQuery.toBuilder() : null;
        }

        public final void setRetrievalQuery(KnowledgeBaseQuery.BuilderImpl retrievalQuery) {
            this.retrievalQuery = retrievalQuery != null ? retrievalQuery.build() : null;
        }

        @Override
        public final Builder retrievalQuery(KnowledgeBaseQuery retrievalQuery) {
            this.retrievalQuery = retrievalQuery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetrieveRequest build() {
            return new RetrieveRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetrieveRequest> {
        public Builder knowledgeBaseId(String var1);

        public Builder nextToken(String var1);

        public Builder retrievalConfiguration(KnowledgeBaseRetrievalConfiguration var1);

        default public Builder retrievalConfiguration(Consumer<KnowledgeBaseRetrievalConfiguration.Builder> retrievalConfiguration) {
            return this.retrievalConfiguration((KnowledgeBaseRetrievalConfiguration)((KnowledgeBaseRetrievalConfiguration.Builder)KnowledgeBaseRetrievalConfiguration.builder().applyMutation(retrievalConfiguration)).build());
        }

        public Builder retrievalQuery(KnowledgeBaseQuery var1);

        default public Builder retrievalQuery(Consumer<KnowledgeBaseQuery.Builder> retrievalQuery) {
            return this.retrievalQuery((KnowledgeBaseQuery)((KnowledgeBaseQuery.Builder)KnowledgeBaseQuery.builder().applyMutation(retrievalQuery)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

