/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.FileSource;
import software.amazon.awssdk.services.bedrockagentruntime.model.FileUseCase;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputFile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputFile> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(InputFile.getter(InputFile::name)).setter(InputFile.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<FileSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(InputFile.getter(InputFile::source)).setter(InputFile.setter(Builder::source)).constructor(FileSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> USE_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("useCase").getter(InputFile.getter(InputFile::useCaseAsString)).setter(InputFile.setter(Builder::useCase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useCase").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOURCE_FIELD, USE_CASE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("source", SOURCE_FIELD);
            this.put("useCase", USE_CASE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final FileSource source;
    private final String useCase;

    private InputFile(BuilderImpl builder) {
        this.name = builder.name;
        this.source = builder.source;
        this.useCase = builder.useCase;
    }

    public final String name() {
        return this.name;
    }

    public final FileSource source() {
        return this.source;
    }

    public final FileUseCase useCase() {
        return FileUseCase.fromValue(this.useCase);
    }

    public final String useCaseAsString() {
        return this.useCase;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.useCaseAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputFile)) {
            return false;
        }
        InputFile other = (InputFile)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.useCaseAsString(), other.useCaseAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InputFile").add("Name", (Object)this.name()).add("Source", (Object)this.source()).add("UseCase", (Object)this.useCaseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "useCase": {
                return Optional.ofNullable(clazz.cast(this.useCaseAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InputFile, T> g) {
        return obj -> g.apply((InputFile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private FileSource source;
        private String useCase;

        private BuilderImpl() {
        }

        private BuilderImpl(InputFile model) {
            this.name(model.name);
            this.source(model.source);
            this.useCase(model.useCase);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final FileSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(FileSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(FileSource source) {
            this.source = source;
            return this;
        }

        public final String getUseCase() {
            return this.useCase;
        }

        public final void setUseCase(String useCase) {
            this.useCase = useCase;
        }

        @Override
        public final Builder useCase(String useCase) {
            this.useCase = useCase;
            return this;
        }

        @Override
        public final Builder useCase(FileUseCase useCase) {
            this.useCase(useCase == null ? null : useCase.toString());
            return this;
        }

        public InputFile build() {
            return new InputFile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputFile> {
        public Builder name(String var1);

        public Builder source(FileSource var1);

        default public Builder source(Consumer<FileSource.Builder> source) {
            return this.source((FileSource)((FileSource.Builder)FileSource.builder().applyMutation(source)).build());
        }

        public Builder useCase(String var1);

        public Builder useCase(FileUseCase var1);
    }
}

