/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Session state provided
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionState implements SdkPojo, Serializable, ToCopyableBuilder<SessionState.Builder, SessionState> {
    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sessionAttributes")
            .getter(getter(SessionState::sessionAttributes))
            .setter(setter(Builder::sessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> PROMPT_SESSION_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("promptSessionAttributes")
            .getter(getter(SessionState::promptSessionAttributes))
            .setter(setter(Builder::promptSessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSessionAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ATTRIBUTES_FIELD,
            PROMPT_SESSION_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> sessionAttributes;

    private final Map<String, String> promptSessionAttributes;

    private SessionState(BuilderImpl builder) {
        this.sessionAttributes = builder.sessionAttributes;
        this.promptSessionAttributes = builder.promptSessionAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionAttributes() {
        return sessionAttributes != null && !(sessionAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Session Attributes
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionAttributes} method.
     * </p>
     * 
     * @return Session Attributes
     */
    public final Map<String, String> sessionAttributes() {
        return sessionAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the PromptSessionAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPromptSessionAttributes() {
        return promptSessionAttributes != null && !(promptSessionAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Prompt Session Attributes
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPromptSessionAttributes} method.
     * </p>
     * 
     * @return Prompt Session Attributes
     */
    public final Map<String, String> promptSessionAttributes() {
        return promptSessionAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionAttributes() ? sessionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPromptSessionAttributes() ? promptSessionAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionState)) {
            return false;
        }
        SessionState other = (SessionState) obj;
        return hasSessionAttributes() == other.hasSessionAttributes()
                && Objects.equals(sessionAttributes(), other.sessionAttributes())
                && hasPromptSessionAttributes() == other.hasPromptSessionAttributes()
                && Objects.equals(promptSessionAttributes(), other.promptSessionAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionState").add("SessionAttributes", hasSessionAttributes() ? sessionAttributes() : null)
                .add("PromptSessionAttributes", hasPromptSessionAttributes() ? promptSessionAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionAttributes":
            return Optional.ofNullable(clazz.cast(sessionAttributes()));
        case "promptSessionAttributes":
            return Optional.ofNullable(clazz.cast(promptSessionAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionState, T> g) {
        return obj -> g.apply((SessionState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionState> {
        /**
         * <p>
         * Session Attributes
         * </p>
         * 
         * @param sessionAttributes
         *        Session Attributes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionAttributes(Map<String, String> sessionAttributes);

        /**
         * <p>
         * Prompt Session Attributes
         * </p>
         * 
         * @param promptSessionAttributes
         *        Prompt Session Attributes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptSessionAttributes(Map<String, String> promptSessionAttributes);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> promptSessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SessionState model) {
            sessionAttributes(model.sessionAttributes);
            promptSessionAttributes(model.promptSessionAttributes);
        }

        public final Map<String, String> getSessionAttributes() {
            if (sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return sessionAttributes;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = SessionAttributesMapCopier.copy(sessionAttributes);
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = SessionAttributesMapCopier.copy(sessionAttributes);
            return this;
        }

        public final Map<String, String> getPromptSessionAttributes() {
            if (promptSessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return promptSessionAttributes;
        }

        public final void setPromptSessionAttributes(Map<String, String> promptSessionAttributes) {
            this.promptSessionAttributes = PromptSessionAttributesMapCopier.copy(promptSessionAttributes);
        }

        @Override
        public final Builder promptSessionAttributes(Map<String, String> promptSessionAttributes) {
            this.promptSessionAttributes = PromptSessionAttributesMapCopier.copy(promptSessionAttributes);
            return this;
        }

        @Override
        public SessionState build() {
            return new SessionState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
