/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalResultLocationType;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalResultS3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrievalResultLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrievalResultLocation> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RetrievalResultLocation.getter(RetrievalResultLocation::typeAsString)).setter(RetrievalResultLocation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<RetrievalResultS3Location> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Location").getter(RetrievalResultLocation.getter(RetrievalResultLocation::s3Location)).setter(RetrievalResultLocation.setter(Builder::s3Location)).constructor(RetrievalResultS3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, S3_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final RetrievalResultS3Location s3Location;

    private RetrievalResultLocation(BuilderImpl builder) {
        this.type = builder.type;
        this.s3Location = builder.s3Location;
    }

    public final RetrievalResultLocationType type() {
        return RetrievalResultLocationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final RetrievalResultS3Location s3Location() {
        return this.s3Location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalResultLocation)) {
            return false;
        }
        RetrievalResultLocation other = (RetrievalResultLocation)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.s3Location(), other.s3Location());
    }

    public final String toString() {
        return ToString.builder((String)"RetrievalResultLocation").add("Type", (Object)this.typeAsString()).add("S3Location", (Object)this.s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrievalResultLocation, T> g) {
        return obj -> g.apply((RetrievalResultLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private RetrievalResultS3Location s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalResultLocation model) {
            this.type(model.type);
            this.s3Location(model.s3Location);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrievalResultLocationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final RetrievalResultS3Location.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        public final void setS3Location(RetrievalResultS3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(RetrievalResultS3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public RetrievalResultLocation build() {
            return new RetrievalResultLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrievalResultLocation> {
        public Builder type(String var1);

        public Builder type(RetrievalResultLocationType var1);

        public Builder s3Location(RetrievalResultS3Location var1);

        default public Builder s3Location(Consumer<RetrievalResultS3Location.Builder> s3Location) {
            return this.s3Location((RetrievalResultS3Location)((RetrievalResultS3Location.Builder)RetrievalResultS3Location.builder().applyMutation(s3Location)).build());
        }
    }
}

