/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.NodeRangePropertiesCopier;
import software.amazon.awssdk.services.batch.model.NodeRangeProperty;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeProperties> {
    private static final SdkField<Integer> NUM_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(NodeProperties.getter(NodeProperties::numNodes)).setter(NodeProperties.setter(Builder::numNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numNodes").build()}).build();
    private static final SdkField<Integer> MAIN_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(NodeProperties.getter(NodeProperties::mainNode)).setter(NodeProperties.setter(Builder::mainNode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mainNode").build()}).build();
    private static final SdkField<List<NodeRangeProperty>> NODE_RANGE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(NodeProperties.getter(NodeProperties::nodeRangeProperties)).setter(NodeProperties.setter(Builder::nodeRangeProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRangeProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeRangeProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_NODES_FIELD, MAIN_NODE_FIELD, NODE_RANGE_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer numNodes;
    private final Integer mainNode;
    private final List<NodeRangeProperty> nodeRangeProperties;

    private NodeProperties(BuilderImpl builder) {
        this.numNodes = builder.numNodes;
        this.mainNode = builder.mainNode;
        this.nodeRangeProperties = builder.nodeRangeProperties;
    }

    public Integer numNodes() {
        return this.numNodes;
    }

    public Integer mainNode() {
        return this.mainNode;
    }

    public List<NodeRangeProperty> nodeRangeProperties() {
        return this.nodeRangeProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.mainNode());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeRangeProperties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeProperties)) {
            return false;
        }
        NodeProperties other = (NodeProperties)obj;
        return Objects.equals(this.numNodes(), other.numNodes()) && Objects.equals(this.mainNode(), other.mainNode()) && Objects.equals(this.nodeRangeProperties(), other.nodeRangeProperties());
    }

    public String toString() {
        return ToString.builder((String)"NodeProperties").add("NumNodes", (Object)this.numNodes()).add("MainNode", (Object)this.mainNode()).add("NodeRangeProperties", this.nodeRangeProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "numNodes": {
                return Optional.ofNullable(clazz.cast(this.numNodes()));
            }
            case "mainNode": {
                return Optional.ofNullable(clazz.cast(this.mainNode()));
            }
            case "nodeRangeProperties": {
                return Optional.ofNullable(clazz.cast(this.nodeRangeProperties()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeProperties, T> g) {
        return obj -> g.apply((NodeProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer numNodes;
        private Integer mainNode;
        private List<NodeRangeProperty> nodeRangeProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeProperties model) {
            this.numNodes(model.numNodes);
            this.mainNode(model.mainNode);
            this.nodeRangeProperties(model.nodeRangeProperties);
        }

        public final Integer getNumNodes() {
            return this.numNodes;
        }

        @Override
        public final Builder numNodes(Integer numNodes) {
            this.numNodes = numNodes;
            return this;
        }

        public final void setNumNodes(Integer numNodes) {
            this.numNodes = numNodes;
        }

        public final Integer getMainNode() {
            return this.mainNode;
        }

        @Override
        public final Builder mainNode(Integer mainNode) {
            this.mainNode = mainNode;
            return this;
        }

        public final void setMainNode(Integer mainNode) {
            this.mainNode = mainNode;
        }

        public final Collection<NodeRangeProperty.Builder> getNodeRangeProperties() {
            return this.nodeRangeProperties != null ? (Collection)this.nodeRangeProperties.stream().map(NodeRangeProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeRangeProperties(Collection<NodeRangeProperty> nodeRangeProperties) {
            this.nodeRangeProperties = NodeRangePropertiesCopier.copy(nodeRangeProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeRangeProperties(NodeRangeProperty ... nodeRangeProperties) {
            this.nodeRangeProperties(Arrays.asList(nodeRangeProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeRangeProperties(Consumer<NodeRangeProperty.Builder> ... nodeRangeProperties) {
            this.nodeRangeProperties(Stream.of(nodeRangeProperties).map(c -> (NodeRangeProperty)((NodeRangeProperty.Builder)NodeRangeProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodeRangeProperties(Collection<NodeRangeProperty.BuilderImpl> nodeRangeProperties) {
            this.nodeRangeProperties = NodeRangePropertiesCopier.copyFromBuilder(nodeRangeProperties);
        }

        public NodeProperties build() {
            return new NodeProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeProperties> {
        public Builder numNodes(Integer var1);

        public Builder mainNode(Integer var1);

        public Builder nodeRangeProperties(Collection<NodeRangeProperty> var1);

        public Builder nodeRangeProperties(NodeRangeProperty ... var1);

        public Builder nodeRangeProperties(Consumer<NodeRangeProperty.Builder> ... var1);
    }
}

