/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MountPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MountPoint> {
    private static final SdkField<String> CONTAINER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MountPoint.getter(MountPoint::containerPath)).setter(MountPoint.setter(Builder::containerPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPath").build()}).build();
    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(MountPoint.getter(MountPoint::readOnly)).setter(MountPoint.setter(Builder::readOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnly").build()}).build();
    private static final SdkField<String> SOURCE_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MountPoint.getter(MountPoint::sourceVolume)).setter(MountPoint.setter(Builder::sourceVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVolume").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PATH_FIELD, READ_ONLY_FIELD, SOURCE_VOLUME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerPath;
    private final Boolean readOnly;
    private final String sourceVolume;

    private MountPoint(BuilderImpl builder) {
        this.containerPath = builder.containerPath;
        this.readOnly = builder.readOnly;
        this.sourceVolume = builder.sourceVolume;
    }

    public String containerPath() {
        return this.containerPath;
    }

    public Boolean readOnly() {
        return this.readOnly;
    }

    public String sourceVolume() {
        return this.sourceVolume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVolume());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MountPoint)) {
            return false;
        }
        MountPoint other = (MountPoint)obj;
        return Objects.equals(this.containerPath(), other.containerPath()) && Objects.equals(this.readOnly(), other.readOnly()) && Objects.equals(this.sourceVolume(), other.sourceVolume());
    }

    public String toString() {
        return ToString.builder((String)"MountPoint").add("ContainerPath", (Object)this.containerPath()).add("ReadOnly", (Object)this.readOnly()).add("SourceVolume", (Object)this.sourceVolume()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerPath": {
                return Optional.ofNullable(clazz.cast(this.containerPath()));
            }
            case "readOnly": {
                return Optional.ofNullable(clazz.cast(this.readOnly()));
            }
            case "sourceVolume": {
                return Optional.ofNullable(clazz.cast(this.sourceVolume()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MountPoint, T> g) {
        return obj -> g.apply((MountPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerPath;
        private Boolean readOnly;
        private String sourceVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(MountPoint model) {
            this.containerPath(model.containerPath);
            this.readOnly(model.readOnly);
            this.sourceVolume(model.sourceVolume);
        }

        public final String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        public final Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public final String getSourceVolume() {
            return this.sourceVolume;
        }

        @Override
        public final Builder sourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
            return this;
        }

        public final void setSourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
        }

        public MountPoint build() {
            return new MountPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MountPoint> {
        public Builder containerPath(String var1);

        public Builder readOnly(Boolean var1);

        public Builder sourceVolume(String var1);
    }
}

