/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobsRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, ListJobsRequest> {
    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListJobsRequest.getter(ListJobsRequest::jobQueue)).setter(ListJobsRequest.setter(Builder::jobQueue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()}).build();
    private static final SdkField<String> ARRAY_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListJobsRequest.getter(ListJobsRequest::arrayJobId)).setter(ListJobsRequest.setter(Builder::arrayJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayJobId").build()}).build();
    private static final SdkField<String> MULTI_NODE_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListJobsRequest.getter(ListJobsRequest::multiNodeJobId)).setter(ListJobsRequest.setter(Builder::multiNodeJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiNodeJobId").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListJobsRequest.getter(ListJobsRequest::jobStatusAsString)).setter(ListJobsRequest.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListJobsRequest.getter(ListJobsRequest::maxResults)).setter(ListJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListJobsRequest.getter(ListJobsRequest::nextToken)).setter(ListJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_QUEUE_FIELD, ARRAY_JOB_ID_FIELD, MULTI_NODE_JOB_ID_FIELD, JOB_STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String jobQueue;
    private final String arrayJobId;
    private final String multiNodeJobId;
    private final String jobStatus;
    private final Integer maxResults;
    private final String nextToken;

    private ListJobsRequest(BuilderImpl builder) {
        super(builder);
        this.jobQueue = builder.jobQueue;
        this.arrayJobId = builder.arrayJobId;
        this.multiNodeJobId = builder.multiNodeJobId;
        this.jobStatus = builder.jobStatus;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String jobQueue() {
        return this.jobQueue;
    }

    public String arrayJobId() {
        return this.arrayJobId;
    }

    public String multiNodeJobId() {
        return this.multiNodeJobId;
    }

    public JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrayJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiNodeJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest)((Object)obj);
        return Objects.equals(this.jobQueue(), other.jobQueue()) && Objects.equals(this.arrayJobId(), other.arrayJobId()) && Objects.equals(this.multiNodeJobId(), other.multiNodeJobId()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListJobsRequest").add("JobQueue", (Object)this.jobQueue()).add("ArrayJobId", (Object)this.arrayJobId()).add("MultiNodeJobId", (Object)this.multiNodeJobId()).add("JobStatus", (Object)this.jobStatusAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobQueue": {
                return Optional.ofNullable(clazz.cast(this.jobQueue()));
            }
            case "arrayJobId": {
                return Optional.ofNullable(clazz.cast(this.arrayJobId()));
            }
            case "multiNodeJobId": {
                return Optional.ofNullable(clazz.cast(this.multiNodeJobId()));
            }
            case "jobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsRequest, T> g) {
        return obj -> g.apply((ListJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String jobQueue;
        private String arrayJobId;
        private String multiNodeJobId;
        private String jobStatus;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsRequest model) {
            super(model);
            this.jobQueue(model.jobQueue);
            this.arrayJobId(model.arrayJobId);
            this.multiNodeJobId(model.multiNodeJobId);
            this.jobStatus(model.jobStatus);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getJobQueue() {
            return this.jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getArrayJobId() {
            return this.arrayJobId;
        }

        @Override
        public final Builder arrayJobId(String arrayJobId) {
            this.arrayJobId = arrayJobId;
            return this;
        }

        public final void setArrayJobId(String arrayJobId) {
            this.arrayJobId = arrayJobId;
        }

        public final String getMultiNodeJobId() {
            return this.multiNodeJobId;
        }

        @Override
        public final Builder multiNodeJobId(String multiNodeJobId) {
            this.multiNodeJobId = multiNodeJobId;
            return this;
        }

        public final void setMultiNodeJobId(String multiNodeJobId) {
            this.multiNodeJobId = multiNodeJobId;
        }

        public final String getJobStatusAsString() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobsRequest build() {
            return new ListJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobsRequest> {
        public Builder jobQueue(String var1);

        public Builder arrayJobId(String var1);

        public Builder multiNodeJobId(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

